/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.support;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderMatcher;
import org.apache.hc.core5.http.HeadersMatcher;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.http.support.BasicResponseBuilder;
import org.apache.hc.core5.net.URIAuthority;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBasicMessageBuilders {
    TestBasicMessageBuilders() {
    }

    @Test
    void testResponseBasics() {
        BasicResponseBuilder builder = BasicResponseBuilder.create((int)200);
        Assertions.assertEquals((int)200, (int)builder.getStatus());
        Assertions.assertNull((Object)builder.getHeaders());
        Assertions.assertNull((Object)builder.getVersion());
        BasicHttpResponse r1 = builder.build();
        Assertions.assertNotNull((Object)r1);
        Assertions.assertEquals((int)200, (int)r1.getCode());
        Assertions.assertNull((Object)r1.getVersion());
        builder.setStatus(500);
        builder.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        Assertions.assertEquals((int)500, (int)builder.getStatus());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)builder.getVersion());
        BasicHttpResponse r2 = builder.build();
        Assertions.assertEquals((int)500, (int)r2.getCode());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)r2.getVersion());
        builder.addHeader("h1", "v1");
        builder.addHeader("h1", "v2");
        builder.addHeader("h2", "v2");
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2"), new BasicHeader("h2", (Object)"v2")}));
        MatcherAssert.assertThat((Object)builder.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2")}));
        MatcherAssert.assertThat((Object)builder.getFirstHeader("h1"), HeaderMatcher.same("h1", "v1"));
        MatcherAssert.assertThat((Object)builder.getLastHeader("h1"), HeaderMatcher.same("h1", "v2"));
        BasicHttpResponse r3 = builder.build();
        MatcherAssert.assertThat((Object)r3.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2"), new BasicHeader("h2", (Object)"v2")}));
        MatcherAssert.assertThat((Object)r3.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2")}));
        MatcherAssert.assertThat((Object)r3.getFirstHeader("h1"), HeaderMatcher.same("h1", "v1"));
        MatcherAssert.assertThat((Object)r3.getLastHeader("h1"), HeaderMatcher.same("h1", "v2"));
        builder.removeHeader((Header)new BasicHeader("h1", (Object)"v2"));
        MatcherAssert.assertThat((Object)builder.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1")}));
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h2", (Object)"v2")}));
        BasicHttpResponse r4 = builder.build();
        MatcherAssert.assertThat((Object)r4.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1")}));
        MatcherAssert.assertThat((Object)r4.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h2", (Object)"v2")}));
        builder.removeHeaders("h1");
        MatcherAssert.assertThat((Object)builder.getHeaders("h1"), HeadersMatcher.same(new Header[0]));
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h2", (Object)"v2")}));
        BasicHttpResponse r5 = builder.build();
        MatcherAssert.assertThat((Object)r5.getHeaders("h1"), HeadersMatcher.same(new Header[0]));
        MatcherAssert.assertThat((Object)r5.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h2", (Object)"v2")}));
    }

    @Test
    void testRequestBasics() throws Exception {
        BasicRequestBuilder builder = BasicRequestBuilder.get();
        Assertions.assertEquals((Object)URI.create("/"), (Object)builder.getUri());
        Assertions.assertEquals((Object)"GET", (Object)builder.getMethod());
        Assertions.assertNull((Object)builder.getScheme());
        Assertions.assertNull((Object)builder.getAuthority());
        Assertions.assertNull((Object)builder.getPath());
        Assertions.assertNull((Object)builder.getHeaders());
        Assertions.assertNull((Object)builder.getVersion());
        Assertions.assertNull((Object)builder.getCharset());
        Assertions.assertNull((Object)builder.getParameters());
        BasicHttpRequest r1 = builder.build();
        Assertions.assertNotNull((Object)r1);
        Assertions.assertEquals((Object)"GET", (Object)r1.getMethod());
        Assertions.assertNull((Object)r1.getScheme());
        Assertions.assertNull((Object)r1.getAuthority());
        Assertions.assertNull((Object)r1.getPath());
        Assertions.assertEquals((Object)URI.create("/"), (Object)r1.getUri());
        Assertions.assertNull((Object)r1.getVersion());
        builder.setUri(URI.create("http://host:1234/blah?param=value"));
        builder.setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        Assertions.assertEquals((Object)"http", (Object)builder.getScheme());
        Assertions.assertEquals((Object)new URIAuthority("host", 1234), (Object)builder.getAuthority());
        Assertions.assertEquals((Object)"/blah?param=value", (Object)builder.getPath());
        Assertions.assertEquals((Object)URI.create("http://host:1234/blah?param=value"), (Object)builder.getUri());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)builder.getVersion());
        BasicHttpRequest r2 = builder.build();
        Assertions.assertEquals((Object)"GET", (Object)r2.getMethod());
        Assertions.assertEquals((Object)"http", (Object)r2.getScheme());
        Assertions.assertEquals((Object)new URIAuthority("host", 1234), (Object)r2.getAuthority());
        Assertions.assertEquals((Object)"/blah?param=value", (Object)r2.getPath());
        Assertions.assertEquals((Object)URI.create("http://host:1234/blah?param=value"), (Object)r2.getUri());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)builder.getVersion());
        builder.setCharset(StandardCharsets.US_ASCII);
        builder.addParameter("param1", "value1");
        builder.addParameter("param2", null);
        builder.addParameters(new NameValuePair[]{new BasicNameValuePair("param3", "value3"), new BasicNameValuePair("param4", null)});
        Assertions.assertEquals((Object)builder.getParameters(), Arrays.asList(new BasicNameValuePair("param1", "value1"), new BasicNameValuePair("param2", null), new BasicNameValuePair("param3", "value3"), new BasicNameValuePair("param4", null)));
        Assertions.assertEquals((Object)URI.create("http://host:1234/blah?param=value"), (Object)builder.getUri());
        BasicHttpRequest r3 = builder.build();
        Assertions.assertEquals((Object)"GET", (Object)r3.getMethod());
        Assertions.assertEquals((Object)"http", (Object)r3.getScheme());
        Assertions.assertEquals((Object)new URIAuthority("host", 1234), (Object)r3.getAuthority());
        Assertions.assertEquals((Object)"/blah?param=value&param1=value1&param2&param3=value3&param4", (Object)r3.getPath());
        Assertions.assertEquals((Object)URI.create("http://host:1234/blah?param=value&param1=value1&param2&param3=value3&param4"), (Object)r3.getUri());
        builder.addHeader("h1", "v1");
        builder.addHeader("h1", "v2");
        builder.addHeader("h2", "v2");
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2"), new BasicHeader("h2", (Object)"v2")}));
        MatcherAssert.assertThat((Object)builder.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2")}));
        MatcherAssert.assertThat((Object)builder.getFirstHeader("h1"), HeaderMatcher.same("h1", "v1"));
        MatcherAssert.assertThat((Object)builder.getLastHeader("h1"), HeaderMatcher.same("h1", "v2"));
        BasicHttpRequest r4 = builder.build();
        MatcherAssert.assertThat((Object)r4.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2"), new BasicHeader("h2", (Object)"v2")}));
        MatcherAssert.assertThat((Object)r4.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2")}));
        MatcherAssert.assertThat((Object)r4.getFirstHeader("h1"), HeaderMatcher.same("h1", "v1"));
        MatcherAssert.assertThat((Object)r4.getLastHeader("h1"), HeaderMatcher.same("h1", "v2"));
        builder.removeHeader((Header)new BasicHeader("h1", (Object)"v2"));
        MatcherAssert.assertThat((Object)builder.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1")}));
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h2", (Object)"v2")}));
        BasicHttpRequest r5 = builder.build();
        MatcherAssert.assertThat((Object)r5.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1")}));
        MatcherAssert.assertThat((Object)r5.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h2", (Object)"v2")}));
        builder.removeHeaders("h1");
        MatcherAssert.assertThat((Object)builder.getHeaders("h1"), HeadersMatcher.same(new Header[0]));
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h2", (Object)"v2")}));
        BasicHttpRequest r6 = builder.build();
        MatcherAssert.assertThat((Object)r6.getHeaders("h1"), HeadersMatcher.same(new Header[0]));
        MatcherAssert.assertThat((Object)r6.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h2", (Object)"v2")}));
    }

    @Test
    void testResponseCopy() {
        BasicHttpResponse response = new BasicHttpResponse(400);
        response.addHeader("h1", (Object)"v1");
        response.addHeader("h1", (Object)"v2");
        response.addHeader("h2", (Object)"v2");
        response.setVersion((ProtocolVersion)HttpVersion.HTTP_2);
        BasicResponseBuilder builder = BasicResponseBuilder.copy((HttpResponse)response);
        Assertions.assertEquals((int)400, (int)builder.getStatus());
        Assertions.assertEquals((Object)HttpVersion.HTTP_2, (Object)builder.getVersion());
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2"), new BasicHeader("h2", (Object)"v2")}));
    }

    @Test
    void testRequestCopy() {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, URI.create("https://host:3456/stuff?blah"));
        request.addHeader("h1", (Object)"v1");
        request.addHeader("h1", (Object)"v2");
        request.addHeader("h2", (Object)"v2");
        request.setVersion((ProtocolVersion)HttpVersion.HTTP_2);
        BasicRequestBuilder builder = BasicRequestBuilder.copy((HttpRequest)request);
        Assertions.assertEquals((Object)"GET", (Object)builder.getMethod());
        Assertions.assertEquals((Object)"https", (Object)builder.getScheme());
        Assertions.assertEquals((Object)new URIAuthority("host", 3456), (Object)builder.getAuthority());
        Assertions.assertEquals((Object)"/stuff?blah", (Object)builder.getPath());
        Assertions.assertEquals((Object)HttpVersion.HTTP_2, (Object)builder.getVersion());
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2"), new BasicHeader("h2", (Object)"v2")}));
    }

    @Test
    void testIDNIntegration() {
        String url = "http://m\u00fcller.example.com:8080/path";
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, URI.create("http://m\u00fcller.example.com:8080/path"));
        Assertions.assertEquals((Object)new URIAuthority("xn--mller-kva.example.com", 8080), (Object)request.getAuthority());
    }
}

