/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mem;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;

public class NumaAllocUtil {
    private static final String extension = ".so";
    private static final String libraryName = "libnuma_alloc";
    public static final int NUMA_NODES_CNT;

    private NumaAllocUtil() {
    }

    private static String getLibName() {
        return Paths.get("/org/apache/ignite/internal/mem", NumaAllocUtil.getOSName(), NumaAllocUtil.getOSArch(), "libnuma_alloc.so").toString();
    }

    private static String getOSArch() {
        return System.getProperty("os.arch", "");
    }

    private static String getOSName() {
        if (System.getProperty("os.name", "").contains("Linux")) {
            return "linux";
        }
        throw new UnsupportedOperationException("Operating System is not supported");
    }

    public static native long allocate(long var0);

    public static native long allocateOnNode(long var0, int var2);

    public static native long allocateLocal(long var0);

    public static native long allocateInterleaved(long var0, int[] var2);

    public static native long chunkSize(long var0);

    public static native void free(long var0);

    private static native int nodesCount();

    static {
        String libName = NumaAllocUtil.getLibName();
        File nativeLib = null;
        try (InputStream in = NumaAllocUtil.class.getResourceAsStream(libName);){
            if (in == null) {
                throw new ExceptionInInitializerError("Failed to load native numa_alloc library, " + libName + " not found");
            }
            nativeLib = File.createTempFile(libraryName, extension);
            try (FileOutputStream out = new FileOutputStream(nativeLib);){
                int bytesRead;
                byte[] buf = new byte[4096];
                while ((bytesRead = in.read(buf)) > 0) {
                    out.write(buf, 0, bytesRead);
                }
            }
            System.load(nativeLib.getAbsolutePath());
            NUMA_NODES_CNT = NumaAllocUtil.nodesCount();
        }
        catch (IOException | UnsatisfiedLinkError e) {
            throw new ExceptionInInitializerError(e);
        }
        finally {
            if (nativeLib != null) {
                nativeLib.deleteOnExit();
            }
        }
    }
}

