/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.ObjectStreamException;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;

public class BinaryTreeSet
implements Binarylizable {
    private TreeSet set;

    public BinaryTreeSet() {
    }

    public BinaryTreeSet(TreeSet set) {
        this.set = set;
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter rawWriter = writer.rawWriter();
        rawWriter.writeObject(this.set.comparator());
        int size = this.set.size();
        rawWriter.writeInt(size);
        for (Object val : this.set) {
            rawWriter.writeObject(val);
        }
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader rawReader = reader.rawReader();
        Comparator comp = (Comparator)rawReader.readObject();
        this.set = comp == null ? new TreeSet() : new TreeSet(comp);
        int size = rawReader.readInt();
        for (int i = 0; i < size; ++i) {
            this.set.add(rawReader.readObject());
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.set;
    }
}

