/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.UUID;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClusterNode;

public class ZkIgnitePaths {
    static final String PATH_SEPARATOR = "/";
    private static final byte CLIENT_NODE_FLAG_MASK = 1;
    private static final int UUID_LEN = 36;
    private static final String JOIN_DATA_DIR = "jd";
    private static final String CUSTOM_EVTS_DIR = "ce";
    private static final String CUSTOM_EVTS_PARTS_DIR = "cp";
    private static final String CUSTOM_EVTS_ACKS_DIR = "ca";
    private static final String STOPPED_NODES_FLAGS_DIR = "sf";
    static final String ALIVE_NODES_DIR = "n";
    private static final String DISCO_EVENTS_PATH = "e";
    final String clusterDir;
    final String aliveNodesDir;
    final String joinDataDir;
    final String evtsPath;
    final String customEvtsDir;
    final String customEvtsPartsDir;
    final String customEvtsAcksDir;
    final String stoppedNodesFlagsDir;

    ZkIgnitePaths(String zkRootPath) {
        this.clusterDir = zkRootPath;
        this.aliveNodesDir = this.zkPath(ALIVE_NODES_DIR);
        this.joinDataDir = this.zkPath(JOIN_DATA_DIR);
        this.evtsPath = this.zkPath(DISCO_EVENTS_PATH);
        this.customEvtsDir = this.zkPath(CUSTOM_EVTS_DIR);
        this.customEvtsPartsDir = this.zkPath(CUSTOM_EVTS_PARTS_DIR);
        this.customEvtsAcksDir = this.zkPath(CUSTOM_EVTS_ACKS_DIR);
        this.stoppedNodesFlagsDir = this.zkPath(STOPPED_NODES_FLAGS_DIR);
    }

    private String zkPath(String path) {
        return ZkIgnitePaths.join(this.clusterDir, path);
    }

    String joiningNodeDataPath(UUID nodeId, UUID prefixId) {
        return ZkIgnitePaths.join(this.joinDataDir, prefixId + ":" + nodeId.toString());
    }

    static long aliveInternalId(String path) {
        int idx = path.lastIndexOf(124);
        return Long.parseLong(path.substring(idx + 1));
    }

    String aliveNodePathForCreate(String prefix, ZookeeperClusterNode node) {
        byte flags = 0;
        if (node.isClient()) {
            flags = (byte)(flags | 1);
        }
        return ZkIgnitePaths.join(this.aliveNodesDir, prefix + ":" + node.id() + ":" + ZkIgnitePaths.encodeFlags(flags) + "|");
    }

    static boolean aliveNodeClientFlag(String path) {
        return (ZkIgnitePaths.aliveFlags(path) & 1) != 0;
    }

    static UUID aliveNodePrefixId(String path) {
        return UUID.fromString(path.substring(0, 36));
    }

    static UUID aliveNodeId(String path) {
        int startIdx = 37;
        String idStr = path.substring(startIdx, startIdx + 36);
        return UUID.fromString(idStr);
    }

    String nodeStoppedFlag(ZookeeperClusterNode node) {
        String path = node.id().toString() + "|" + node.internalId();
        return ZkIgnitePaths.join(this.stoppedNodesFlagsDir, path);
    }

    static long stoppedFlagNodeInternalId(String path) {
        int idx = path.lastIndexOf(124);
        return Long.parseLong(path.substring(idx + 1));
    }

    static int customEventSequence(String path) {
        int idx = path.lastIndexOf(124);
        return Integer.parseInt(path.substring(idx + 1));
    }

    static UUID customEventSendNodeId(String path) {
        int startIdx = 37;
        String idStr = path.substring(startIdx, startIdx + 36);
        return UUID.fromString(idStr);
    }

    static String customEventPrefix(String path) {
        return path.substring(0, 36);
    }

    static int customEventPartsCount(String path) {
        int startIdx = 74;
        String cntStr = path.substring(startIdx, startIdx + 4);
        int partCnt = Integer.parseInt(cntStr);
        assert (partCnt >= 1) : partCnt;
        return partCnt;
    }

    String createCustomEventPath(String prefix, UUID nodeId, int partCnt) {
        return ZkIgnitePaths.join(this.customEvtsDir, prefix + ":" + nodeId + ":" + String.format("%04d", partCnt) + "|");
    }

    String customEventPartsBasePath(String prefix, UUID nodeId) {
        return ZkIgnitePaths.join(this.customEvtsPartsDir, prefix + ":" + nodeId + ":");
    }

    String customEventPartPath(String prefix, UUID nodeId, int part) {
        return this.customEventPartsBasePath(prefix, nodeId) + String.format("%04d", part);
    }

    String joinEventDataPathForJoined(long evtId) {
        return ZkIgnitePaths.join(this.evtsPath, "fj-" + evtId);
    }

    String joinEventSecuritySubjectPath(long topVer) {
        return ZkIgnitePaths.join(this.evtsPath, "s-" + topVer);
    }

    String ackEventDataPath(long origEvtId) {
        assert (origEvtId != 0L);
        return ZkIgnitePaths.join(this.customEvtsAcksDir, String.valueOf(origEvtId));
    }

    String distributedFutureBasePath(UUID id) {
        return ZkIgnitePaths.join(this.evtsPath, "f-" + id);
    }

    String distributedFutureResultPath(UUID id) {
        return ZkIgnitePaths.join(this.evtsPath, "fr-" + id);
    }

    private static String encodeFlags(byte flags) {
        int intVal = flags + 128;
        Object str = Integer.toString(intVal, 16);
        if (((String)str).length() == 1) {
            str = "0" + (String)str;
        }
        assert (((String)str).length() == 2) : str;
        return str;
    }

    private static byte aliveFlags(String path) {
        int startIdx = path.lastIndexOf(58) + 1;
        String flagsStr = path.substring(startIdx, startIdx + 2);
        return (byte)(Integer.parseInt(flagsStr, 16) - 128);
    }

    public static String join(String ... paths) {
        return String.join((CharSequence)PATH_SEPARATOR, paths);
    }

    public static String validatePath(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Path length must be > 0");
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with / character");
        }
        if (path.length() == 1) {
            return path;
        }
        if (path.charAt(path.length() - 1) == '/') {
            throw new IllegalArgumentException("Path must not end with / character");
        }
        String reason = null;
        int prev = 47;
        char[] chars = path.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u0000') {
                reason = "null character not allowed @" + i;
                break;
            }
            if (c == '/' && prev == 47) {
                reason = "empty node name specified @" + i;
                break;
            }
            if (c == '.' && (i + 1 == chars.length || chars[i + 1] == '/') && (chars[i - 2] == '/' && prev == 46 || chars[i - 1] == '/')) {
                reason = "relative paths not allowed @" + i;
                break;
            }
            if (c > '\u0000' && c < '\u001f' || c > '\u007f' && c < '\u009f' || c > '\ud800' && c < '\uf8ff' || c > '\ufff0' && c < '\uffff') {
                reason = "invalid charater @" + i;
                break;
            }
            prev = chars[i];
        }
        if (reason != null) {
            throw new IllegalArgumentException("Invalid path string \"" + path + "\" caused by " + reason);
        }
        return path;
    }
}

