/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class VarInts {
    private VarInts() {
    }

    public static void writeUnsignedInt(int value, DataOutput output) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException(value + " is negative");
        }
        if (value < 255) {
            output.writeByte(value);
        } else if (value < 65535) {
            output.writeByte(255);
            output.writeShort(value);
        } else {
            output.writeByte(255);
            output.writeShort(65535);
            output.writeInt(value);
        }
    }

    public static int readUnsignedInt(DataInput input) throws IOException {
        int first = input.readUnsignedByte();
        if (first < 255) {
            return first;
        }
        int second = input.readUnsignedShort();
        if (second < 65535) {
            return second;
        }
        int third = input.readInt();
        if (third < 0) {
            throw new IllegalStateException(third + " is negative");
        }
        return third;
    }
}

