/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.util.IgniteStripedBusyLock;
import org.apache.ignite.internal.util.TrackerClosedException;
import org.jetbrains.annotations.Nullable;

public class PendingComparableValuesTracker<T extends Comparable<T>, R>
implements ManuallyCloseable {
    protected static final VarHandle CURRENT;
    private static final VarHandle CLOSE_GUARD;
    private final ConcurrentSkipListMap<T, CompletableFuture<R>> valueFutures = new ConcurrentSkipListMap();
    protected volatile Map.Entry<T, @Nullable R> current;
    private volatile boolean closeGuard;
    private final IgniteStripedBusyLock busyLock = new IgniteStripedBusyLock();
    protected final Comparator<Map.Entry<T, @Nullable R>> comparator;

    public PendingComparableValuesTracker(T initialValue) {
        this.current = new IgniteBiTuple<T, Object>(initialValue, null);
        this.comparator = Map.Entry.comparingByKey(Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(T newValue, @Nullable R futureResult) {
        while (true) {
            if (!this.enterBusy()) {
                throw new TrackerClosedException();
            }
            try {
                Map.Entry<T, @Nullable R> current = this.current;
                IgniteBiTuple<T, @Nullable R> newEntry = new IgniteBiTuple<T, R>(newValue, futureResult);
                if (this.comparator.compare(newEntry, current) <= 0) break;
                if (!CURRENT.compareAndSet(this, current, newEntry)) continue;
                this.completeWaitersOnUpdate(newValue, futureResult);
            }
            finally {
                this.leaveBusy();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<R> waitFor(T valueToWait) {
        if (!this.enterBusy()) {
            return CompletableFuture.failedFuture(new TrackerClosedException());
        }
        try {
            Map.Entry<T, @Nullable R> currentKeyValue = this.current;
            if (((Comparable)currentKeyValue.getKey()).compareTo(valueToWait) >= 0) {
                CompletableFuture<R> completableFuture = CompletableFuture.completedFuture(currentKeyValue.getValue());
                return completableFuture;
            }
            CompletableFuture<R> completableFuture = this.addNewWaiter(valueToWait);
            return completableFuture;
        }
        finally {
            this.leaveBusy();
        }
    }

    public T current() {
        if (!this.enterBusy()) {
            throw new TrackerClosedException();
        }
        try {
            Comparable comparable = (Comparable)this.current.getKey();
            return (T)comparable;
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public void close() {
        this.close(new TrackerClosedException());
    }

    public void close(Exception trackerClosedException) {
        if (!CLOSE_GUARD.compareAndSet(this, false, true)) {
            return;
        }
        this.blockBusy();
        this.cleanupWaitersOnClose(trackerClosedException);
    }

    protected void completeWaitersOnUpdate(T newValue, @Nullable R futureResult) {
        NavigableMap smallerFutures = this.valueFutures.headMap((Object)newValue, true);
        smallerFutures.forEach((k, f) -> f.complete(futureResult));
        smallerFutures.clear();
    }

    protected CompletableFuture<R> addNewWaiter(T valueToWait) {
        CompletableFuture future = this.valueFutures.computeIfAbsent(valueToWait, k -> new CompletableFuture());
        Map.Entry<T, R> currentEntry = this.current;
        if (((Comparable)currentEntry.getKey()).compareTo(valueToWait) >= 0) {
            future.complete(currentEntry.getValue());
            this.valueFutures.remove(valueToWait);
        }
        return future;
    }

    protected void cleanupWaitersOnClose(Exception waiterCompletionException) {
        this.valueFutures.values().forEach(future -> future.completeExceptionally(waiterCompletionException));
        this.valueFutures.clear();
    }

    Map.Entry<T, R> currentEntry() {
        return this.current;
    }

    public boolean isEmpty() {
        return this.valueFutures.isEmpty();
    }

    protected final boolean enterBusy() {
        return this.busyLock.enterBusy();
    }

    protected final void leaveBusy() {
        this.busyLock.leaveBusy();
    }

    private void blockBusy() {
        this.busyLock.block();
    }

    static {
        try {
            CURRENT = MethodHandles.lookup().findVarHandle(PendingComparableValuesTracker.class, "current", Map.Entry.class);
            CLOSE_GUARD = MethodHandles.lookup().findVarHandle(PendingComparableValuesTracker.class, "closeGuard", Boolean.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

