/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.hll.util;

import org.apache.ignite.internal.processors.query.stat.hll.serialization.IWordSerializer;
import org.apache.ignite.internal.processors.query.stat.hll.util.LongIterator;

public class BitVector
implements Cloneable {
    private static final int LOG2_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BITS_PER_WORD_MASK = 63;
    private static final int LOG2_BITS_PER_BYTE = 3;
    public static final int BITS_PER_BYTE = 8;
    public static final int BYTES_PER_WORD = 8;
    private final long[] words;
    private final int registerWidth;
    private final long count;
    private final long registerMask;

    public final long[] words() {
        return this.words;
    }

    public final int wordCount() {
        return this.words.length;
    }

    public final int byteCount() {
        return this.wordCount() * 8;
    }

    public final int registerWidth() {
        return this.registerWidth;
    }

    public BitVector(int width, long count) {
        this.words = new long[(int)((long)width * count + 63L >>> 6)];
        this.registerWidth = width;
        this.count = count;
        this.registerMask = (1L << width) - 1L;
    }

    public long getRegister(long registerIndex) {
        long bitIdx = registerIndex * (long)this.registerWidth;
        int firstWordIdx = (int)(bitIdx >>> 6);
        int secondWordIdx = (int)(bitIdx + (long)this.registerWidth - 1L >>> 6);
        int bitRemainder = (int)(bitIdx & 0x3FL);
        if (firstWordIdx == secondWordIdx) {
            return this.words[firstWordIdx] >>> bitRemainder & this.registerMask;
        }
        return this.words[firstWordIdx] >>> bitRemainder | this.words[secondWordIdx] << 64 - bitRemainder & this.registerMask;
    }

    public void setRegister(long registerIndex, long value) {
        long bitIdx = registerIndex * (long)this.registerWidth;
        int firstWordIdx = (int)(bitIdx >>> 6);
        int secondWordIdx = (int)(bitIdx + (long)this.registerWidth - 1L >>> 6);
        int bitRemainder = (int)(bitIdx & 0x3FL);
        long[] words = this.words;
        if (firstWordIdx == secondWordIdx) {
            int n = firstWordIdx;
            words[n] = words[n] & (this.registerMask << bitRemainder ^ 0xFFFFFFFFFFFFFFFFL);
            int n2 = firstWordIdx;
            words[n2] = words[n2] | value << bitRemainder;
        } else {
            int n = firstWordIdx;
            words[n] = words[n] & (1L << bitRemainder) - 1L;
            int n3 = firstWordIdx;
            words[n3] = words[n3] | value << bitRemainder;
            int n4 = secondWordIdx;
            words[n4] = words[n4] & (this.registerMask >>> 64 - bitRemainder ^ 0xFFFFFFFFFFFFFFFFL);
            int n5 = secondWordIdx;
            words[n5] = words[n5] | value >>> 64 - bitRemainder;
        }
    }

    public LongIterator registerIterator() {
        LongIterator longIter = new LongIterator(){
            final int registerWidth;
            final long[] words;
            final long registerMask;
            long registerIndex;
            int wordIdx;
            int remainingWordBits;
            long word;
            {
                this.registerWidth = BitVector.this.registerWidth;
                this.words = BitVector.this.words;
                this.registerMask = BitVector.this.registerMask;
                this.registerIndex = 0L;
                this.wordIdx = 0;
                this.remainingWordBits = 64;
                this.word = this.words[this.wordIdx];
            }

            @Override
            public long next() {
                long register;
                if (this.remainingWordBits >= this.registerWidth) {
                    register = this.word & this.registerMask;
                    this.word >>>= this.registerWidth;
                    this.remainingWordBits -= this.registerWidth;
                } else {
                    ++this.wordIdx;
                    register = (this.word | this.words[this.wordIdx] << this.remainingWordBits) & this.registerMask;
                    this.word = this.words[this.wordIdx] >>> this.registerWidth - this.remainingWordBits;
                    this.remainingWordBits += 64 - this.registerWidth;
                }
                ++this.registerIndex;
                return register;
            }

            @Override
            public boolean hasNext() {
                return this.registerIndex < BitVector.this.count;
            }
        };
        return longIter;
    }

    public boolean setMaxRegister(long registerIndex, long value) {
        long bitIdx = registerIndex * (long)this.registerWidth;
        int firstWordIdx = (int)(bitIdx >>> 6);
        int secondWordIdx = (int)(bitIdx + (long)this.registerWidth - 1L >>> 6);
        int bitRemainder = (int)(bitIdx & 0x3FL);
        long[] words = this.words;
        long registerVal = firstWordIdx == secondWordIdx ? words[firstWordIdx] >>> bitRemainder & this.registerMask : words[firstWordIdx] >>> bitRemainder | words[secondWordIdx] << 64 - bitRemainder & this.registerMask;
        if (value > registerVal) {
            if (firstWordIdx == secondWordIdx) {
                int n = firstWordIdx;
                words[n] = words[n] & (this.registerMask << bitRemainder ^ 0xFFFFFFFFFFFFFFFFL);
                int n2 = firstWordIdx;
                words[n2] = words[n2] | value << bitRemainder;
            } else {
                int n = firstWordIdx;
                words[n] = words[n] & (1L << bitRemainder) - 1L;
                int n3 = firstWordIdx;
                words[n3] = words[n3] | value << bitRemainder;
                int n4 = secondWordIdx;
                words[n4] = words[n4] & (this.registerMask >>> 64 - bitRemainder ^ 0xFFFFFFFFFFFFFFFFL);
                int n5 = secondWordIdx;
                words[n5] = words[n5] | value >>> 64 - bitRemainder;
            }
        }
        return value >= registerVal;
    }

    public void fill(long val) {
        for (long i = 0L; i < this.count; ++i) {
            this.setRegister(i, val);
        }
    }

    public void getRegisterContents(IWordSerializer serializer) {
        LongIterator iter = this.registerIterator();
        while (iter.hasNext()) {
            serializer.writeWord(iter.next());
        }
    }

    public BitVector clone() {
        BitVector copy = new BitVector(this.registerWidth, this.count);
        System.arraycopy(this.words, 0, copy.words, 0, this.words.length);
        return copy;
    }
}

