/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.config.ini;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite3.internal.cli.config.ini.IniSection;

public class IniParser {
    public static final String NO_SECTION = "NO_SECTION";
    private static final Pattern SECTION_PATTERN = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
    private static final Pattern KEY_VALUE_PATTER = Pattern.compile("\\s*([^=]*)=(.*)");
    private static final Pattern COMMENT_LINE = Pattern.compile("^[;|#].*");

    public Map<String, IniSection> parse(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new FileNotFoundException("inputStream is null");
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            Map<String, IniSection> map = this.parseIniFile(bufferedReader);
            return map;
        }
    }

    public Map<String, IniSection> parse(File file) throws IOException {
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            Map<String, IniSection> map = this.parse(input);
            return map;
        }
    }

    private Map<String, IniSection> parseIniFile(BufferedReader bufferedReader) throws IOException {
        String line;
        LinkedHashMap<String, IniSection> map = new LinkedHashMap<String, IniSection>();
        IniSection currentSection = new IniSection(NO_SECTION);
        map.put(NO_SECTION, currentSection);
        while ((line = bufferedReader.readLine()) != null) {
            Matcher commentMatcher = COMMENT_LINE.matcher(line);
            if (commentMatcher.matches()) continue;
            Matcher sectionMather = SECTION_PATTERN.matcher(line);
            if (sectionMather.matches()) {
                String sectionName = sectionMather.group(1).trim();
                currentSection = new IniSection(sectionName);
                map.put(sectionName, currentSection);
                continue;
            }
            Matcher keyValueMatcher = KEY_VALUE_PATTER.matcher(line);
            if (!keyValueMatcher.matches()) continue;
            String key = keyValueMatcher.group(1).trim();
            String value = keyValueMatcher.group(2).trim();
            currentSection.setProperty(key, value);
        }
        return map;
    }
}

