/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.restart;

import java.util.function.Function;
import org.apache.ignite3.Ignite;
import org.apache.ignite3.internal.restart.IgniteAware;

class RefCache<T> {
    private final Function<Ignite, T> supplier;
    private IgniteAware<T> value;

    RefCache(Ignite initialIgnite, Function<Ignite, T> supplier) {
        this.value = new IgniteAware<T>(supplier.apply(initialIgnite), initialIgnite);
        this.supplier = supplier;
    }

    public T actualFor(Ignite ignite) {
        IgniteAware<T> igniteAware = this.value;
        if (igniteAware.ignite() != ignite) {
            igniteAware = new IgniteAware<T>(this.supplier.apply(ignite), ignite);
            this.value = igniteAware;
        }
        return igniteAware.instance();
    }
}

