/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.async;

import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.factory.AsyncThriftClientFactory;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.rpc.TNonblockingSocketWrapper;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.transport.TNonblockingTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncConfigNodeInternalServiceClient
extends IConfigNodeRPCService.AsyncClient
implements ThriftClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncConfigNodeInternalServiceClient.class);
    private long originalTimeout = -1L;
    private final boolean printLogWhenEncounterException;
    private final TEndPoint endpoint;
    private final ClientManager<TEndPoint, AsyncConfigNodeInternalServiceClient> clientManager;

    public AsyncConfigNodeInternalServiceClient(ThriftClientProperty property, TEndPoint endpoint, TAsyncClientManager tClientManager, ClientManager<TEndPoint, AsyncConfigNodeInternalServiceClient> clientManager) throws IOException {
        super(property.getProtocolFactory(), tClientManager, (TNonblockingTransport)TNonblockingSocketWrapper.wrap((String)endpoint.getIp(), (int)endpoint.getPort(), (int)property.getConnectionTimeoutMs()));
        this.setTimeout(property.getConnectionTimeoutMs());
        this.printLogWhenEncounterException = property.isPrintLogWhenEncounterException();
        this.endpoint = endpoint;
        this.clientManager = clientManager;
    }

    public void onComplete() {
        super.onComplete();
        this.returnSelf();
    }

    public void onError(Exception e) {
        super.onError(e);
        ThriftClient.resolveException(e, this);
        this.returnSelf();
    }

    @Override
    public void invalidate() {
        if (!this.hasError()) {
            super.onError(new Exception("This client has been invalidated"));
        }
    }

    @Override
    public void invalidateAll() {
        this.clientManager.clear(this.endpoint);
    }

    @Override
    public boolean printLogWhenEncounterException() {
        return this.printLogWhenEncounterException;
    }

    private void returnSelf() {
        if (this.originalTimeout != -1L) {
            this.recoverTimeout();
        }
        this.clientManager.returnClient(this.endpoint, this);
    }

    public synchronized void setTimeoutTemporarily(long timeout) {
        if (this.originalTimeout != -1L) {
            logger.warn("This client's timeout has been set to {}. If you need to set it to {}, please call the recoverTimeout() first.", (Object)this.originalTimeout, (Object)timeout);
        }
        this.originalTimeout = this.getTimeout();
        this.setTimeout(timeout);
    }

    private synchronized void recoverTimeout() {
        if (this.originalTimeout == -1L) {
            logger.warn("This client's timeout has not been modified, cannot reset");
        }
        this.setTimeout(this.originalTimeout);
        this.originalTimeout = -1L;
    }

    private void close() {
        this.___transport.close();
        this.___currentMethod = null;
    }

    public boolean isReady() {
        try {
            this.checkReady();
            return true;
        }
        catch (Exception e) {
            if (this.printLogWhenEncounterException) {
                logger.error("Unexpected exception occurs in {}, error msg is {}", (Object)this, (Object)ExceptionUtils.getRootCause((Throwable)e).toString());
            }
            return false;
        }
    }

    public String toString() {
        return String.format("AsyncConfigNodeIServiceClient{%s}", this.endpoint);
    }

    public static class Factory
    extends AsyncThriftClientFactory<TEndPoint, AsyncConfigNodeInternalServiceClient> {
        public Factory(ClientManager<TEndPoint, AsyncConfigNodeInternalServiceClient> clientManager, ThriftClientProperty thriftClientProperty, String threadName) {
            super(clientManager, thriftClientProperty, threadName);
        }

        public void destroyObject(TEndPoint endPoint, PooledObject<AsyncConfigNodeInternalServiceClient> pooledObject) {
            ((AsyncConfigNodeInternalServiceClient)pooledObject.getObject()).close();
        }

        public PooledObject<AsyncConfigNodeInternalServiceClient> makeObject(TEndPoint endPoint) throws Exception {
            return new DefaultPooledObject((Object)new AsyncConfigNodeInternalServiceClient(this.thriftClientProperty, endPoint, this.tManagers[this.clientCnt.incrementAndGet() % this.tManagers.length], this.clientManager));
        }

        public boolean validateObject(TEndPoint endPoint, PooledObject<AsyncConfigNodeInternalServiceClient> pooledObject) {
            return ((AsyncConfigNodeInternalServiceClient)pooledObject.getObject()).isReady();
        }
    }
}

