/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailRepositoryKeysDAO {
    private static final String COUNT = "count";
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertKey;
    private final PreparedStatement deleteKey;
    private final PreparedStatement listKeys;
    private final PreparedStatement countKeys;
    private final boolean strongConsistency;

    @Inject
    public CassandraMailRepositoryKeysDAO(CqlSession session, CassandraConfiguration cassandraConfiguration) {
        this.strongConsistency = cassandraConfiguration.isMailRepositoryStrongConsistency();
        this.executor = new CassandraAsyncExecutor(session);
        this.insertKey = this.prepareInsert(session);
        this.deleteKey = this.prepareDelete(session);
        this.listKeys = this.prepareList(session);
        this.countKeys = this.prepareCount(session);
    }

    private PreparedStatement prepareList(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"mailRepositoryKeys").column("mailKey").where((Relation)Relation.column((String)"name").isEqualTo((Term)QueryBuilder.bindMarker((String)"name")))).build());
    }

    private PreparedStatement prepareCount(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"mailRepositoryKeys").countAll().as(COUNT).where((Relation)Relation.column((String)"name").isEqualTo((Term)QueryBuilder.bindMarker((String)"name")))).build());
    }

    private PreparedStatement prepareDelete(CqlSession session) {
        Delete deleteStatement = (Delete)QueryBuilder.deleteFrom((String)"mailRepositoryKeys").where(List.of((Relation)Relation.column((String)"name").isEqualTo((Term)QueryBuilder.bindMarker((String)"name")), (Relation)Relation.column((String)"mailKey").isEqualTo((Term)QueryBuilder.bindMarker((String)"mailKey"))));
        if (this.strongConsistency) {
            return session.prepare(((Delete)deleteStatement.ifExists()).build());
        }
        return session.prepare(deleteStatement.build());
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        RegularInsert insertStatement = QueryBuilder.insertInto((String)"mailRepositoryKeys").value("name", (Term)QueryBuilder.bindMarker((String)"name")).value("mailKey", (Term)QueryBuilder.bindMarker((String)"mailKey"));
        if (this.strongConsistency) {
            return session.prepare(insertStatement.ifNotExists().build());
        }
        return session.prepare(insertStatement.build());
    }

    public Mono<Boolean> store(MailRepositoryUrl url, MailKey key) {
        Mono operation = this.executor.executeReturnApplied((Statement)((BoundStatement)this.insertKey.bind(new Object[0]).setString("name", url.asString())).setString("mailKey", key.asString()));
        if (this.strongConsistency) {
            return operation;
        }
        return operation.switchIfEmpty(Mono.just((Object)true));
    }

    public Flux<MailKey> list(MailRepositoryUrl url) {
        return this.executor.executeRows((Statement)this.listKeys.bind(new Object[0]).setString("name", url.asString())).map(row -> new MailKey(row.getString("mailKey")));
    }

    public Mono<Long> getCount(MailRepositoryUrl url) {
        return this.executor.executeSingleRow((Statement)this.countKeys.bind(new Object[0]).setString("name", url.asString())).map(row -> row.getLong(COUNT)).switchIfEmpty(Mono.just((Object)0L));
    }

    public Mono<Boolean> remove(MailRepositoryUrl url, MailKey key) {
        Mono operation = this.executor.executeReturnApplied((Statement)((BoundStatement)this.deleteKey.bind(new Object[0]).setString("name", url.asString())).setString("mailKey", key.asString()));
        if (this.strongConsistency) {
            return operation;
        }
        return operation.switchIfEmpty(Mono.just((Object)true));
    }
}

