/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.AccessController;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientLargeMessageImpl;
import org.apache.activemq.artemis.core.client.impl.ClientLargeMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.client.impl.CompressedLargeMessageControllerImpl;
import org.apache.activemq.artemis.core.client.impl.LargeMessageControllerImpl;
import org.apache.activemq.artemis.spi.core.remoting.ConsumerContext;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.TokenBucketLimiter;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.PriorityLinkedList;
import org.apache.activemq.artemis.utils.collections.PriorityLinkedListImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientConsumerImpl
implements ClientConsumerInternal {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int NUM_PRIORITIES = 10;
    public static final SimpleString FORCED_DELIVERY_MESSAGE = SimpleString.of((String)"_hornetq.forced.delivery.seq");
    private final ClientSessionInternal session;
    private final SessionContext sessionContext;
    private final ConsumerContext consumerContext;
    private final SimpleString filterString;
    private final int priority;
    private final SimpleString queueName;
    private final boolean browseOnly;
    private final Executor sessionExecutor;
    private final Executor flowControlExecutor;
    private final ReusableLatch pendingFlowControl = new ReusableLatch(0);
    private final int initialWindow;
    private final int clientWindowSize;
    private final int ackBatchSize;
    private final PriorityLinkedList<ClientMessageInternal> buffer = new PriorityLinkedListImpl(10);
    private final Runner runner = new Runner();
    private LargeMessageControllerImpl currentLargeMessageController;
    private ClientMessageInternal largeMessageReceived;
    private final TokenBucketLimiter rateLimiter;
    private volatile Thread receiverThread;
    private volatile Thread onMessageThread;
    private volatile MessageHandler handler;
    private volatile boolean closing;
    private volatile boolean closed;
    private int creditsToSend;
    private volatile boolean failedOver;
    private volatile Exception lastException;
    private int ackBytes;
    private volatile ClientMessageInternal lastAckedMessage;
    private boolean stopped = false;
    private AtomicLong forceDeliveryCount = new AtomicLong(0L);
    private final ClientSession.QueueQuery queueInfo;
    private volatile boolean ackIndividually;
    private final ClassLoader contextClassLoader;
    private volatile boolean manualFlowManagement;
    private final int onMessageCloseTimeout;

    public ClientConsumerImpl(ClientSessionInternal session, ConsumerContext consumerContext, SimpleString queueName, SimpleString filterString, int priority, boolean browseOnly, int initialWindow, int clientWindowSize, int ackBatchSize, TokenBucketLimiter rateLimiter, Executor executor, Executor flowControlExecutor, SessionContext sessionContext, ClientSession.QueueQuery queueInfo, ClassLoader contextClassLoader, int onMessageCloseTimeout) {
        this.consumerContext = consumerContext;
        this.queueName = queueName;
        this.filterString = filterString;
        this.priority = priority;
        this.browseOnly = browseOnly;
        this.sessionContext = sessionContext;
        this.session = session;
        this.rateLimiter = rateLimiter;
        this.sessionExecutor = executor;
        this.initialWindow = initialWindow;
        this.clientWindowSize = clientWindowSize;
        this.ackBatchSize = ackBatchSize;
        this.queueInfo = queueInfo;
        this.contextClassLoader = contextClassLoader;
        this.flowControlExecutor = flowControlExecutor;
        this.onMessageCloseTimeout = onMessageCloseTimeout;
        if (logger.isTraceEnabled()) {
            logger.trace("{}:: being created at", (Object)this, (Object)new Exception("trace"));
        }
    }

    @Override
    public ConsumerContext getConsumerContext() {
        return this.consumerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientMessage receive(long timeout, boolean forcingDelivery) throws ActiveMQException {
        if (logger.isTraceEnabled()) {
            logger.trace("{}::receive({}, {})", new Object[]{this, timeout, forcingDelivery});
        }
        this.checkClosed();
        if (this.largeMessageReceived != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}::receive({}, {}) -> discard LargeMessage body for {}", new Object[]{this, timeout, forcingDelivery, this.largeMessageReceived});
            }
            this.largeMessageReceived.discardBody();
            this.largeMessageReceived = null;
        }
        if (this.rateLimiter != null) {
            this.rateLimiter.limit();
        }
        if (this.handler != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}::receive({}, {}) -> throwing messageHandlerSet", new Object[]{this, timeout, forcingDelivery});
            }
            throw ActiveMQClientMessageBundle.BUNDLE.messageHandlerSet();
        }
        if (this.clientWindowSize == 0) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}::receive({}, {}) -> start slowConsumer", new Object[]{this, timeout, forcingDelivery});
            }
            this.startSlowConsumer();
        }
        this.receiverThread = Thread.currentThread();
        boolean deliveryForced = false;
        boolean callForceDelivery = false;
        long start = -1L;
        long toWait = timeout == 0L ? Long.MAX_VALUE : timeout;
        try {
            ClientConsumerImpl clientConsumerImpl;
            block33: {
                ClientMessageInternal m;
                block34: {
                    while (true) {
                        m = null;
                        clientConsumerImpl = this;
                        synchronized (clientConsumerImpl) {
                            while ((this.stopped || (m = (ClientMessageInternal)this.buffer.poll()) == null) && !this.closed && toWait > 0L) {
                                if (start == -1L) {
                                    start = System.currentTimeMillis();
                                }
                                if (m == null && forcingDelivery) {
                                    if (this.stopped) break;
                                    if (!deliveryForced) {
                                        callForceDelivery = true;
                                        break;
                                    }
                                }
                                try {
                                    this.wait(toWait);
                                }
                                catch (InterruptedException e) {
                                    throw new ActiveMQInterruptedException((Throwable)e);
                                }
                                if (m != null || this.closed) break;
                                long now = System.currentTimeMillis();
                                toWait -= now - start;
                                start = now;
                            }
                        }
                        if (this.failedOver) {
                            if (m == null) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("{}::receive({}, {}) -> m == null and failover", new Object[]{this, timeout, forcingDelivery});
                                }
                                this.failedOver = false;
                                deliveryForced = false;
                                toWait = timeout == 0L ? Long.MAX_VALUE : timeout;
                                continue;
                            }
                            if (logger.isTraceEnabled()) {
                                logger.trace("{}::receive({}, {}) -> failedOver, but m != null, being {}", new Object[]{this, timeout, forcingDelivery, m});
                            }
                            this.failedOver = false;
                        }
                        if (callForceDelivery) {
                            logger.trace("{}::Forcing delivery", (Object)this);
                            this.sessionContext.forceDelivery(this, this.forceDeliveryCount.getAndIncrement());
                            callForceDelivery = false;
                            deliveryForced = true;
                            continue;
                        }
                        if (m == null) break block33;
                        this.session.workDone();
                        if (m.containsProperty(FORCED_DELIVERY_MESSAGE)) {
                            long seq = m.getLongProperty(FORCED_DELIVERY_MESSAGE);
                            if (forcingDelivery && deliveryForced && seq == this.forceDeliveryCount.get() - 1L) {
                                this.resetIfSlowConsumer();
                                logger.trace("{}::There was nothing on the queue, leaving it now:: returning null", (Object)this);
                                ClientMessage clientMessage = null;
                                return clientMessage;
                            }
                            logger.trace("{}::Ignored force delivery answer as it belonged to another call", (Object)this);
                            continue;
                        }
                        boolean expired = m.isExpired();
                        this.flowControlBeforeConsumption(m);
                        if (!expired) break block34;
                        m.discardBody();
                        this.session.expire(this, m);
                        if (this.clientWindowSize == 0) {
                            this.startSlowConsumer();
                        }
                        if (toWait <= 0L) break;
                    }
                    ClientMessage clientMessage = null;
                    return clientMessage;
                }
                if (m.isLargeMessage()) {
                    this.largeMessageReceived = m;
                }
                logger.trace("{}::Returning {}", (Object)this, (Object)m);
                ClientMessageInternal clientMessageInternal = m;
                return clientMessageInternal;
            }
            logger.trace("{}::Returning null", (Object)this);
            this.resetIfSlowConsumer();
            clientConsumerImpl = null;
            return clientConsumerImpl;
        }
        finally {
            this.receiverThread = null;
        }
    }

    @Override
    public ClientMessage receive(long timeout) throws ActiveMQException {
        logger.trace("{}:: receive({})", (Object)this, (Object)timeout);
        ClientMessage msg = this.receive(timeout, false);
        if (msg == null && !this.closed) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}:: receive({}) -> null, trying again with receive(0)", (Object)this, (Object)timeout);
            }
            msg = this.receive(0L, true);
        }
        logger.trace("{}:: returning {}", (Object)this, (Object)msg);
        return msg;
    }

    @Override
    public ClientMessage receive() throws ActiveMQException {
        return this.receive(0L, false);
    }

    @Override
    public ClientMessage receiveImmediate() throws ActiveMQException {
        return this.receive(0L, true);
    }

    @Override
    public MessageHandler getMessageHandler() throws ActiveMQException {
        this.checkClosed();
        return this.handler;
    }

    @Override
    public Thread getCurrentThread() {
        if (this.onMessageThread != null) {
            return this.onMessageThread;
        }
        return this.receiverThread;
    }

    @Override
    public ClientConsumer setManualFlowMessageHandler(MessageHandler theHandler) throws ActiveMQException {
        this.checkClosed();
        this.handler = theHandler;
        this.manualFlowManagement = true;
        return this;
    }

    @Override
    public synchronized ClientConsumerImpl setMessageHandler(MessageHandler theHandler) throws ActiveMQException {
        boolean noPreviousHandler;
        this.checkClosed();
        if (this.receiverThread != null) {
            throw ActiveMQClientMessageBundle.BUNDLE.inReceive();
        }
        boolean bl = noPreviousHandler = this.handler == null;
        if (this.handler != theHandler && this.clientWindowSize == 0) {
            this.startSlowConsumer();
        }
        this.handler = theHandler;
        if (this.handler != null && noPreviousHandler) {
            this.requeueExecutors();
        } else if (this.handler == null && !noPreviousHandler) {
            this.waitForOnMessageToComplete(true);
        }
        return this;
    }

    @Override
    public void close() throws ActiveMQException {
        this.doCleanUp(true);
    }

    @Override
    public Thread prepareForClose(FutureLatch future) throws ActiveMQException {
        this.closing = true;
        this.resetLargeMessageController();
        this.sessionExecutor.execute(future::run);
        return this.onMessageThread;
    }

    @Override
    public void cleanUp() {
        try {
            this.doCleanUp(false);
        }
        catch (ActiveMQException e) {
            ActiveMQClientLogger.LOGGER.failedCleaningUp(this.toString());
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean waitForOnMessage) throws ActiveMQException {
        if (this.browseOnly) {
            return;
        }
        ClientConsumerImpl clientConsumerImpl = this;
        synchronized (clientConsumerImpl) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
        }
        this.waitForOnMessageToComplete(waitForOnMessage);
    }

    @Override
    public void clearAtFailover() {
        logger.trace("{}::ClearAtFailover", (Object)this);
        this.clearBuffer();
        this.stopped = true;
        this.resetLargeMessageController();
        this.lastAckedMessage = null;
        this.creditsToSend = 0;
        this.failedOver = true;
        this.ackIndividually = false;
    }

    @Override
    public synchronized void start() {
        this.stopped = false;
        this.requeueExecutors();
    }

    @Override
    public Exception getLastException() {
        return this.lastException;
    }

    @Override
    public ClientSession.QueueQuery getQueueInfo() {
        return this.queueInfo;
    }

    @Override
    public long getForceDeliveryCount() {
        return this.forceDeliveryCount.get();
    }

    @Override
    public SimpleString getFilterString() {
        return this.filterString;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }

    @Override
    public boolean isBrowseOnly() {
        return this.browseOnly;
    }

    @Override
    public synchronized void handleMessage(ClientMessageInternal message) throws Exception {
        if (this.closing) {
            return;
        }
        if (message.getBooleanProperty(Message.HDR_LARGE_COMPRESSED).booleanValue()) {
            this.handleCompressedMessage(message);
        } else {
            this.handleRegularMessage(message);
        }
    }

    private void handleRegularMessage(ClientMessageInternal message) {
        if (message.getAddress() == null) {
            message.setAddress(this.queueInfo.getAddress());
        }
        message.onReceipt(this);
        if (!this.ackIndividually && message.getPriority() != 4 && !message.containsProperty(FORCED_DELIVERY_MESSAGE)) {
            this.ackIndividually = true;
        }
        this.buffer.addTail((Object)message, (int)message.getPriority());
        if (this.handler != null) {
            if (!this.stopped) {
                this.queueExecutor();
            }
        } else {
            this.notify();
        }
    }

    private void handleCompressedMessage(ClientMessageInternal clMessage) throws Exception {
        ClientLargeMessageImpl largeMessage = new ClientLargeMessageImpl();
        largeMessage.retrieveExistingData(clMessage);
        File largeMessageCache = null;
        if (this.session.isCacheLargeMessageClient()) {
            largeMessageCache = this.createLargeMessageCache(largeMessage.getMessageID());
        }
        ClientSessionFactory sf = this.session.getSessionFactory();
        ServerLocator locator = sf.getServerLocator();
        long callTimeout = locator.getCallTimeout();
        this.currentLargeMessageController = new LargeMessageControllerImpl(this, largeMessage.getLargeMessageSize(), callTimeout, largeMessageCache);
        this.currentLargeMessageController.setLocal(true);
        ActiveMQBuffer qbuff = clMessage.toCore().getBodyBuffer();
        int bytesToRead = qbuff.writerIndex() - qbuff.readerIndex();
        byte[] body = new byte[bytesToRead];
        qbuff.readBytes(body);
        largeMessage.setLargeMessageController(new CompressedLargeMessageControllerImpl(this.currentLargeMessageController));
        this.currentLargeMessageController.addPacket(body, body.length, false);
        largeMessage.putBooleanProperty(Message.HDR_LARGE_COMPRESSED, false);
        this.handleRegularMessage(largeMessage);
    }

    private File createLargeMessageCache(long messageId) throws IOException {
        File largeMessageCache = File.createTempFile("tmp-large-message-" + messageId + "-", ".tmp");
        largeMessageCache.setReadable(false, false);
        largeMessageCache.setExecutable(false, false);
        largeMessageCache.setWritable(false, false);
        largeMessageCache.setReadable(true, true);
        largeMessageCache.setWritable(true, true);
        largeMessageCache.deleteOnExit();
        return largeMessageCache;
    }

    @Override
    public synchronized void handleLargeMessage(ClientLargeMessageInternal clientLargeMessage, long largeMessageSize) throws Exception {
        if (this.closing) {
            return;
        }
        File largeMessageCache = null;
        if (this.session.isCacheLargeMessageClient()) {
            largeMessageCache = this.createLargeMessageCache(clientLargeMessage.getMessageID());
        }
        ClientSessionFactory sf = this.session.getSessionFactory();
        ServerLocator locator = sf.getServerLocator();
        long callTimeout = locator.getCallTimeout();
        this.currentLargeMessageController = new LargeMessageControllerImpl(this, largeMessageSize, callTimeout, largeMessageCache);
        if (clientLargeMessage.isCompressed()) {
            clientLargeMessage.setLargeMessageController(new CompressedLargeMessageControllerImpl(this.currentLargeMessageController));
            clientLargeMessage.putBooleanProperty(Message.HDR_LARGE_COMPRESSED, false);
        } else {
            clientLargeMessage.setLargeMessageController(this.currentLargeMessageController);
        }
        this.handleRegularMessage(clientLargeMessage);
    }

    @Override
    public synchronized void handleLargeMessageContinuation(byte[] chunk, int flowControlSize, boolean isContinues) throws Exception {
        if (this.closing) {
            return;
        }
        if (this.currentLargeMessageController == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}::Sending back credits for largeController = null {}", (Object)this, (Object)flowControlSize);
            }
            this.flowControl(flowControlSize, false);
        } else {
            this.currentLargeMessageController.addPacket(chunk, flowControlSize, isContinues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(boolean waitForOnMessage) throws ActiveMQException {
        ClientConsumerImpl clientConsumerImpl = this;
        synchronized (clientConsumerImpl) {
            try (LinkedListIterator iter = this.buffer.iterator();){
                while (iter.hasNext()) {
                    ClientMessageInternal message = (ClientMessageInternal)iter.next();
                    if (message.isLargeMessage()) {
                        ClientLargeMessageInternal largeMessage = (ClientLargeMessageInternal)message;
                        largeMessage.getLargeMessageController().cancel();
                    }
                    this.flowControlBeforeConsumption(message);
                }
            }
            catch (Exception e) {
                ActiveMQClientLogger.LOGGER.errorClearingMessages(e);
            }
            this.clearBuffer();
            try {
                this.resetLargeMessageController();
            }
            catch (Throwable e) {
                ActiveMQClientLogger.LOGGER.errorClearingMessages(e);
            }
        }
        this.waitForOnMessageToComplete(waitForOnMessage);
    }

    private void resetLargeMessageController() {
        LargeMessageControllerImpl controller = this.currentLargeMessageController;
        if (controller != null) {
            controller.cancel();
            this.currentLargeMessageController = null;
        }
    }

    @Override
    public int getInitialWindowSize() {
        return this.initialWindow;
    }

    @Override
    public int getClientWindowSize() {
        return this.clientWindowSize;
    }

    @Override
    public int getBufferSize() {
        return this.buffer.size();
    }

    @Override
    public void acknowledge(ClientMessage message) throws ActiveMQException {
        ClientMessageInternal cmi = (ClientMessageInternal)message;
        if (this.ackIndividually) {
            this.individualAcknowledge(message);
        } else {
            this.ackBytes += message.getEncodeSize();
            if (logger.isTraceEnabled()) {
                logger.trace("{}::acknowledge ackBytes={} and ackBatchSize={}, encodeSize={}", new Object[]{this, this.ackBytes, this.ackBatchSize, message.getEncodeSize()});
            }
            if (this.ackBytes >= this.ackBatchSize) {
                logger.trace("{}:: acknowledge acking {}", (Object)this, (Object)cmi);
                this.doAck(cmi);
            } else {
                logger.trace("{}:: acknowledge setting lastAckedMessage = {}", (Object)this, (Object)cmi);
                this.lastAckedMessage = cmi;
            }
        }
    }

    @Override
    public void individualAcknowledge(ClientMessage message) throws ActiveMQException {
        if (this.lastAckedMessage != null) {
            this.flushAcks();
        }
        this.session.individualAcknowledge(this, message);
    }

    @Override
    public void flushAcks() throws ActiveMQException {
        if (this.lastAckedMessage != null) {
            logger.trace("{}::FlushACK acking lastMessage::{}", (Object)this, (Object)this.lastAckedMessage);
            this.doAck(this.lastAckedMessage);
        }
    }

    @Override
    public void flowControl(int messageBytes, boolean discountSlowConsumer) throws ActiveMQException {
        if (this.clientWindowSize >= 0) {
            this.creditsToSend += messageBytes;
            if (this.creditsToSend >= this.clientWindowSize) {
                if (this.clientWindowSize == 0 && discountSlowConsumer) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("{}::FlowControl::Sending {}-1, for slow consumer", (Object)this, (Object)this.creditsToSend);
                    }
                    int credits = this.creditsToSend - 1;
                    this.creditsToSend = 0;
                    if (credits > 0) {
                        this.sendCredits(credits);
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Sending {} from flow-control", (Object)messageBytes);
                    }
                    int credits = this.creditsToSend;
                    this.creditsToSend = 0;
                    if (credits > 0) {
                        this.sendCredits(credits);
                    }
                }
            }
        }
    }

    private void startSlowConsumer() {
        logger.trace("{}::Sending 1 credit to start delivering of one message to slow consumer", (Object)this);
        this.sendCredits(1);
        try {
            this.pendingFlowControl.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void resetIfSlowConsumer() {
        if (this.clientWindowSize == 0) {
            this.sendCredits(0);
            CountDownLatch latch = new CountDownLatch(1);
            this.flowControlExecutor.execute(latch::countDown);
            try {
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new ActiveMQInterruptedException((Throwable)e);
            }
        }
    }

    private void requeueExecutors() {
        for (int i = 0; i < this.buffer.size(); ++i) {
            this.queueExecutor();
        }
    }

    private void queueExecutor() {
        logger.trace("{}::Adding Runner on Executor for delivery", (Object)this);
        this.sessionExecutor.execute(this.runner);
    }

    private void sendCredits(int credits) {
        this.pendingFlowControl.countUp();
        this.flowControlExecutor.execute(() -> {
            try {
                this.sessionContext.sendConsumerCredits(this, credits);
            }
            finally {
                this.pendingFlowControl.countDown();
            }
        });
    }

    private void waitForOnMessageToComplete(boolean waitForOnMessage) {
        if (this.handler == null) {
            return;
        }
        if (!waitForOnMessage || Thread.currentThread() == this.onMessageThread) {
            return;
        }
        FutureLatch future = new FutureLatch();
        this.sessionExecutor.execute(future);
        if (this.onMessageCloseTimeout == -1) {
            future.await();
        } else if (!future.await(this.onMessageCloseTimeout)) {
            ActiveMQClientLogger.LOGGER.timeOutWaitingForProcessing(this.onMessageCloseTimeout);
        }
    }

    private void checkClosed() throws ActiveMQException {
        if (this.closed) {
            throw ActiveMQClientMessageBundle.BUNDLE.consumerClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOnMessage() throws Exception {
        if (this.closing || this.stopped) {
            return;
        }
        this.session.workDone();
        MessageHandler theHandler = this.handler;
        if (theHandler != null) {
            ClientMessageInternal message;
            if (this.rateLimiter != null) {
                this.rateLimiter.limit();
            }
            this.failedOver = false;
            ClientConsumerImpl clientConsumerImpl = this;
            synchronized (clientConsumerImpl) {
                message = (ClientMessageInternal)this.buffer.poll();
            }
            if (message != null) {
                if (message.containsProperty(FORCED_DELIVERY_MESSAGE)) {
                    return;
                }
                boolean expired = message.isExpired();
                this.flowControlBeforeConsumption(message);
                if (!expired) {
                    logger.trace("{}::Calling handler.onMessage", (Object)this);
                    ClassLoader originalLoader = this.safeInstallContextClassLoader();
                    this.onMessageThread = Thread.currentThread();
                    try {
                        theHandler.onMessage(message);
                    }
                    finally {
                        try {
                            this.safeRestoreContextClassLoader(originalLoader);
                        }
                        catch (Exception e) {
                            ActiveMQClientLogger.LOGGER.failedPerformPostActionsOnMessage(e);
                        }
                        this.onMessageThread = null;
                    }
                    logger.trace("{}::Handler.onMessage done", (Object)this);
                } else {
                    theHandler.onMessageExpired(message);
                    logger.trace("{}::Handler.onMessageExpired done", (Object)this);
                    this.session.expire(this, message);
                }
                if (message.isLargeMessage()) {
                    message.discardBody();
                }
                if (this.clientWindowSize == 0) {
                    this.startSlowConsumer();
                }
            }
        }
    }

    private ClassLoader unsafeInstallContextClassLoader() {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalCl = currentThread.getContextClassLoader();
        if (Objects.equals(originalCl, this.contextClassLoader)) {
            return originalCl;
        }
        currentThread.setContextClassLoader(this.contextClassLoader);
        return originalCl;
    }

    private ClassLoader safeInstallContextClassLoader() {
        if (System.getSecurityManager() == null) {
            try {
                return this.unsafeInstallContextClassLoader();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return AccessController.doPrivileged(this::unsafeInstallContextClassLoader);
    }

    private void safeRestoreContextClassLoader(ClassLoader originalClassLoader) {
        if (Objects.equals(originalClassLoader, this.contextClassLoader)) {
            return;
        }
        if (System.getSecurityManager() == null) {
            try {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                return;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        AccessController.doPrivileged(() -> {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            return null;
        });
    }

    private void flowControlBeforeConsumption(ClientMessageInternal message) throws ActiveMQException {
        if (this.manualFlowManagement) {
            return;
        }
        if (message.getFlowControlSize() != 0) {
            this.flowControl(message.getFlowControlSize(), !message.isLargeMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanUp(boolean sendCloseMessage) throws ActiveMQException {
        try {
            if (this.closed) {
                return;
            }
            this.closing = true;
            this.waitForOnMessageToComplete(true);
            this.resetLargeMessageController();
            this.closed = true;
            ClientConsumerImpl clientConsumerImpl = this;
            synchronized (clientConsumerImpl) {
                if (this.receiverThread != null) {
                    this.notify();
                }
                this.handler = null;
                this.receiverThread = null;
            }
            this.flushAcks();
            this.clearBuffer();
            if (sendCloseMessage) {
                this.sessionContext.closeConsumer(this);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.session.removeConsumer(this);
    }

    private void clearBuffer() {
        this.buffer.clear();
    }

    private void doAck(ClientMessageInternal message) throws ActiveMQException {
        this.ackBytes = 0;
        this.lastAckedMessage = null;
        logger.trace("{}::Acking message {}", (Object)this, (Object)message);
        this.session.acknowledge(this, message);
    }

    public String toString() {
        return super.toString() + "{consumerContext=" + String.valueOf(this.consumerContext) + ", queueName=" + String.valueOf(this.queueName) + "}";
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            try {
                ClientConsumerImpl.this.callOnMessage();
            }
            catch (Exception e) {
                ActiveMQClientLogger.LOGGER.onMessageError(e);
                ClientConsumerImpl.this.lastException = e;
            }
        }
    }
}

