/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BitConstantNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasVariantValueNodeVisitor;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderByNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowCountNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class RowResultSetNode
extends FromTable {
    SubqueryList subquerys;
    private List<AggregateNode> aggregates;
    ResultSetNode.QueryExpressionClauses qec = new ResultSetNode.QueryExpressionClauses();

    RowResultSetNode(ResultColumnList resultColumnList, Properties properties, ContextManager contextManager) {
        super(null, properties, contextManager);
        this.setResultColumns(resultColumnList);
        if (this.getResultColumns() != null) {
            this.getResultColumns().markInitialSize();
        }
    }

    String statementToString() {
        return "VALUES";
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.subquerys != null && this.subquerys.referencesSessionSchema();
    }

    @Override
    ResultSetNode enhanceRCLForInsert(InsertNode insertNode, boolean bl, int[] nArray) throws StandardException {
        if (!bl || this.getResultColumns().size() < insertNode.resultColumnList.size()) {
            this.setResultColumns(this.getRCLForInsert(insertNode, nArray));
        }
        return this;
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        if (this.getCostEstimate() == null) {
            this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        }
        this.getCostEstimate().setCost(0.0, 1.0, 1.0);
        rowOrdering.optimizableAlwaysOrdered(this);
        return this.getCostEstimate();
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    @Override
    void bindExpressions(FromList fromList) throws StandardException {
        this.subquerys = new SubqueryList(this.getContextManager());
        this.aggregates = new ArrayList<AggregateNode>();
        this.getResultColumns().checkForInvalidDefaults();
        int n = fromList.size() == 0 ? 0 : ((FromTable)fromList.elementAt(0)).getLevel() + 1;
        this.setLevel(n);
        fromList.insertElementAt(this, 0);
        this.getResultColumns().bindExpressions(fromList, this.subquerys, this.aggregates);
        fromList.removeElementAt(0);
        if (!this.aggregates.isEmpty()) {
            throw StandardException.newException((String)"42903", (Object[])new Object[0]);
        }
        SelectNode.checkNoWindowFunctions(this.getResultColumns(), "VALUES");
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList orderByList = this.qec.getOrderByList(i);
            if (orderByList != null) {
                orderByList.pullUpOrderByColumns(this);
                orderByList.bindOrderByColumns(this);
            }
            RowResultSetNode.bindOffsetFetch(this.qec.getOffset(i), this.qec.getFetchFirst(i));
        }
    }

    @Override
    void bindExpressionsWithTables(FromList fromList) throws StandardException {
    }

    @Override
    void bindTargetExpressions(FromList fromList) throws StandardException {
        this.bindExpressions(fromList);
    }

    @Override
    void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        if (resultColumnList == null) {
            resultColumnList = this.getResultColumns();
        }
        this.getResultColumns().bindUntypedNullsToResultColumns(resultColumnList);
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        return null;
    }

    @Override
    String getExposedName() throws StandardException {
        return null;
    }

    @Override
    void verifySelectStarSubquery(FromList fromList, int n) throws StandardException {
    }

    @Override
    public void pushQueryExpressionSuffix() {
        this.qec.push();
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.qec.setOrderByList(orderByList);
    }

    @Override
    void pushOffsetFetchFirst(ValueNode valueNode, ValueNode valueNode2, boolean bl) {
        this.qec.setOffset(valueNode);
        this.qec.setFetchFirst(valueNode2);
        this.qec.setHasJDBCLimitClause(bl);
    }

    @Override
    ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        this.getResultColumns().preprocess(n, fromList, this.subquerys, new PredicateList(this.getContextManager()));
        this.setReferencedTableMap(new JBitSet(n));
        this.getReferencedTableMap().set(this.tableNumber);
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList orderByList = this.qec.getOrderByList(i);
            if (orderByList == null || orderByList.size() <= 1) continue;
            orderByList.removeDupColumns();
        }
        return this;
    }

    @Override
    ResultSetNode ensurePredicateList(int n) throws StandardException {
        return this.genProjectRestrict(n);
    }

    @Override
    ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        ResultColumnList resultColumnList = this.getResultColumns();
        this.setResultColumns(this.getResultColumns().copyListAndObjects());
        resultColumnList.genVirtualColumnNodes(this, this.getResultColumns());
        PredicateList predicateList = new PredicateList(this.getContextManager());
        predicateList.addPredicate(predicate);
        return new ProjectRestrictNode(this, resultColumnList, null, predicateList, null, null, this.tableProperties, this.getContextManager());
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        if (this.subquerys != null && this.subquerys.size() > 0) {
            return false;
        }
        if (this.aggregates != null && !this.aggregates.isEmpty()) {
            return false;
        }
        if (!this.getResultColumns().isCloneable()) {
            return false;
        }
        boolean bl = false;
        int n = fromList.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)fromList.elementAt(i);
            if (fromTable instanceof FromSubquery) {
                ResultSetNode resultSetNode = ((FromSubquery)fromTable).getSubquery();
                if (resultSetNode instanceof RowResultSetNode) continue;
                bl = true;
                break;
            }
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.getCostEstimate().setCost(0.0, d, d);
        this.subquerys.optimize(dataDictionary, d);
        return this;
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        return (Optimizable)((Object)this.modifyAccessPaths());
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        FromTable fromTable = this;
        this.subquerys.modifyAccessPaths();
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList orderByList = this.qec.getOrderByList(i);
            if (orderByList != null) {
                fromTable = new OrderByNode(fromTable, orderByList, this.tableProperties, this.getContextManager());
            }
            ValueNode valueNode = this.qec.getOffset(i);
            ValueNode valueNode2 = this.qec.getFetchFirst(i);
            Boolean bl = this.qec.getHasJDBCLimitClause()[i];
            if (valueNode == null && valueNode2 == null) continue;
            ResultColumnList resultColumnList = fromTable.getResultColumns().copyListAndObjects();
            resultColumnList.genVirtualColumnNodes(fromTable, fromTable.getResultColumns());
            fromTable = new RowCountNode(fromTable, resultColumnList, valueNode, valueNode2, bl, this.getContextManager());
        }
        return fromTable;
    }

    @Override
    boolean returnsAtMostOneRow() {
        return true;
    }

    @Override
    void setTableConstructorTypes(ResultColumnList resultColumnList) throws StandardException {
        int n = this.getResultColumns().size();
        for (int i = 0; i < n; ++i) {
            TypeId typeId;
            ResultColumn resultColumn;
            ResultColumn resultColumn2 = (ResultColumn)this.getResultColumns().elementAt(i);
            ValueNode valueNode = resultColumn2.getExpression();
            if (valueNode.requiresTypeFromContext()) {
                resultColumn = (ResultColumn)resultColumnList.elementAt(i);
                valueNode.setType(resultColumn.getTypeServices());
                continue;
            }
            if (valueNode instanceof CharConstantNode) {
                resultColumn = (ResultColumn)resultColumnList.elementAt(i);
                typeId = resultColumn.getTypeId();
                if (typeId.isStringTypeId()) {
                    if (typeId.getJDBCTypeId() == 1) continue;
                    int n2 = valueNode.getTypeServices().getMaximumWidth();
                    valueNode.setType(new DataTypeDescriptor(typeId, true, n2));
                    continue;
                }
                if (!typeId.isBitTypeId()) continue;
                if (typeId.getJDBCTypeId() == -3) {
                    TypeId typeId2 = TypeId.getBuiltInTypeId(12);
                    valueNode.setType(new DataTypeDescriptor(typeId2, true));
                    resultColumnList.setElementAt(resultColumn, i);
                    continue;
                }
                if (typeId.getJDBCTypeId() != -4) continue;
                TypeId typeId3 = TypeId.getBuiltInTypeId(-1);
                valueNode.setType(new DataTypeDescriptor(typeId3, true));
                resultColumnList.setElementAt(resultColumn, i);
                continue;
            }
            if (!(valueNode instanceof BitConstantNode)) continue;
            resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            typeId = resultColumn.getTypeId();
            if (typeId.isBitTypeId()) {
                if (typeId.getJDBCTypeId() == -2 || typeId.getJDBCTypeId() == 2004) continue;
                int n3 = valueNode.getTypeServices().getMaximumWidth();
                valueNode.setType(new DataTypeDescriptor(typeId, true, n3));
                continue;
            }
            if (!typeId.isStringTypeId()) continue;
            if (typeId.getJDBCTypeId() == 12) {
                TypeId typeId4 = TypeId.getBuiltInTypeId(-3);
                valueNode.setType(new DataTypeDescriptor(typeId4, true));
                resultColumnList.setElementAt(resultColumn, i);
                continue;
            }
            if (typeId.getJDBCTypeId() != -1) continue;
            TypeId typeId5 = TypeId.getBuiltInTypeId(-4);
            valueNode.setType(new DataTypeDescriptor(typeId5, true));
            resultColumnList.setElementAt(resultColumn, i);
        }
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.setCostEstimate(this.getFinalCostEstimate());
        boolean bl = this.canWeCacheResults();
        this.assignResultSetNumber();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        this.getResultColumns().generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(bl);
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getRowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 6);
    }

    @Override
    void replaceOrForbidDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList, boolean bl) throws StandardException {
        this.getResultColumns().replaceOrForbidDefaults(tableDescriptor, resultColumnList, bl);
    }

    @Override
    void optimizeSubqueries(DataDictionary dataDictionary, double d) throws StandardException {
        this.subquerys.optimize(dataDictionary, d);
    }

    @Override
    void adjustForSortElimination() {
    }

    private boolean canWeCacheResults() throws StandardException {
        HasVariantValueNodeVisitor hasVariantValueNodeVisitor = new HasVariantValueNodeVisitor(2, true);
        super.accept(hasVariantValueNodeVisitor);
        boolean bl = !hasVariantValueNodeVisitor.hasVariant();
        return bl;
    }
}

