/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.mailbox.Authorizator;

public class FakeAuthorizator
implements Authorizator {
    private final Optional<Username> givenUserId;
    private final Optional<Username> delegatedUserId;

    public static FakeAuthorizator defaultReject() {
        return new FakeAuthorizator(Optional.empty(), Optional.empty());
    }

    public static FakeAuthorizator forGivenUserAndDelegatedUser(Username givenUser, Username delegatedUser) {
        return new FakeAuthorizator(Optional.of(givenUser), Optional.of(delegatedUser));
    }

    private FakeAuthorizator(Optional<Username> givenUserId, Optional<Username> userId) {
        this.givenUserId = givenUserId;
        this.delegatedUserId = userId;
    }

    public Authorizator.AuthorizationState canLoginAsOtherUser(Username userId, Username otherUserId) {
        if (this.givenUserId.isEmpty() || this.delegatedUserId.isEmpty()) {
            return Authorizator.AuthorizationState.FORBIDDEN;
        }
        if (!this.givenUserId.get().equals((Object)userId)) {
            return Authorizator.AuthorizationState.FORBIDDEN;
        }
        if (!otherUserId.equals((Object)this.delegatedUserId.get())) {
            return Authorizator.AuthorizationState.UNKNOWN_USER;
        }
        return Authorizator.AuthorizationState.ALLOWED;
    }
}

