/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.BouncyCastleFIPSHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PropertyManager;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadLocalSecureRandom;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.JVMDefaultTrustManager;
import com.unboundid.util.ssl.TLSCipherSuiteSelector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CryptoHelper {
    @NotNull
    public static final String PROPERTY_FIPS_MODE = "com.unboundid.crypto.FIPS_MODE";
    @NotNull
    public static final String PROPERTY_FIPS_PROVIDER = "com.unboundid.crypto.FIPS_PROVIDER";
    @NotNull
    public static final String PROPERTY_REMOVE_NON_NECESSARY_PROVIDERS = "com.unboundid.crypto.REMOVE_NON_ESSENTIAL_PROVIDERS";
    @NotNull
    public static final String PROPERTY_ALLOWED_FIPS_MODE_PROVIDER = "com.unboundid.crypto.ALLOWED_FIPS_MODE_PROVIDER";
    @NotNull
    private static final Set<String> ALLOWED_FIPS_MODE_PROVIDERS;
    @NotNull
    private static final AtomicBoolean FIPS_MODE;
    @NotNull
    private static final AtomicReference<Provider> FIPS_PROVIDER;
    @NotNull
    private static final AtomicReference<Provider> FIPS_JSSE_PROVIDER;
    @NotNull
    private static final AtomicReference<String> FIPS_DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM;
    @NotNull
    private static final AtomicReference<String> FIPS_DEFAULT_KEY_STORE_TYPE;
    @NotNull
    private static final AtomicReference<String> FIPS_DEFAULT_SSL_CONTEXT_PROTOCOL;
    @NotNull
    private static final AtomicReference<String[]> FIPS_ALTERNATIVE_DEFAULT_SSL_CONTEXT_PROTOCOLS;
    @NotNull
    private static final AtomicReference<String> FIPS_DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM;
    @NotNull
    private static final AtomicReference<String> FIPS_PROVIDER_NAME;
    @NotNull
    private static final AtomicReference<Provider> DEFAULT_JSSE_PROVIDER;
    @NotNull
    public static final String KEY_STORE_TYPE_BCFKS = "BCFKS";
    @NotNull
    public static final String KEY_STORE_TYPE_JKS = "JKS";
    @NotNull
    public static final String KEY_STORE_TYPE_PKCS_11 = "PKCS11";
    @NotNull
    public static final String KEY_STORE_TYPE_PKCS_12 = "PKCS12";
    @NotNull
    public static final String PROPERTY_DEFAULT_KEY_STORE_TYPE = "com.unboundid.crypto.DEFAULT_KEY_STORE_TYPE";
    @NotNull
    private static final AtomicReference<String> DEFAULT_KEY_STORE_TYPE;
    @NotNull
    private static final String SECURE_RANDOM_SERVICE_TYPE = "SecureRandom";
    @Nullable
    private static final Provider NULL_PROVIDER;

    private CryptoHelper() {
    }

    public static boolean usingFIPSMode() {
        return FIPS_MODE.get();
    }

    @Nullable
    public static String getFIPSModeProviderName() {
        return FIPS_PROVIDER_NAME.get();
    }

    public static void setUseFIPSMode(boolean useFIPSMode) throws NoSuchProviderException {
        if (useFIPSMode) {
            CryptoHelper.setUseFIPSMode("BCFIPS");
        } else {
            FIPS_MODE.set(false);
            FIPS_PROVIDER_NAME.set(null);
        }
    }

    public static void setUseFIPSMode(@NotNull String providerName) throws NoSuchProviderException {
        Provider jsseProvider;
        Provider fipsProvider;
        if (providerName.equalsIgnoreCase("BCFIPS")) {
            fipsProvider = BouncyCastleFIPSHelper.loadBouncyCastleFIPSProvider(true);
            jsseProvider = BouncyCastleFIPSHelper.loadBouncyCastleJSSEProvider(true);
            FIPS_PROVIDER_NAME.set("BCFIPS");
        } else if (providerName.equalsIgnoreCase("BCFIPS1")) {
            fipsProvider = BouncyCastleFIPSHelper.loadBouncyCastleFIPSProvider(true, "1");
            jsseProvider = BouncyCastleFIPSHelper.loadBouncyCastleJSSEProvider(true, "1");
            FIPS_PROVIDER_NAME.set("BCFIPS1");
        } else if (providerName.equalsIgnoreCase("BCFIPS2")) {
            fipsProvider = BouncyCastleFIPSHelper.loadBouncyCastleFIPSProvider(true, "2");
            jsseProvider = BouncyCastleFIPSHelper.loadBouncyCastleJSSEProvider(true, "2");
            FIPS_PROVIDER_NAME.set("BCFIPS2");
        } else {
            throw new NoSuchProviderException(UtilityMessages.ERR_CRYPTO_HELPER_UNSUPPORTED_FIPS_PROVIDER.get(providerName, "BCFIPS"));
        }
        FIPS_PROVIDER.set(fipsProvider);
        FIPS_JSSE_PROVIDER.set(jsseProvider);
        FIPS_DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM.set("X.509");
        FIPS_DEFAULT_KEY_STORE_TYPE.set(KEY_STORE_TYPE_BCFKS);
        FIPS_DEFAULT_SSL_CONTEXT_PROTOCOL.set("DEFAULT");
        FIPS_ALTERNATIVE_DEFAULT_SSL_CONTEXT_PROTOCOLS.set(BouncyCastleFIPSHelper.ALTERNATIVE_DEFAULT_SSL_CONTEXT_PROTOCOLS);
        FIPS_DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM.set("PKIX");
        FIPS_MODE.set(true);
        TLSCipherSuiteSelector.recompute();
    }

    @NotNull
    public static Set<String> getAllowedFIPSModeProviders() {
        return Collections.unmodifiableSet(ALLOWED_FIPS_MODE_PROVIDERS);
    }

    public static void addAllowedFIPSModeProvider(@NotNull String providerClass) {
        ALLOWED_FIPS_MODE_PROVIDERS.add(providerClass);
    }

    public static void removeNonEssentialSecurityProviders() {
        for (Provider provider : Security.getProviders()) {
            if (ALLOWED_FIPS_MODE_PROVIDERS.contains(provider.getClass().getName())) continue;
            Security.removeProvider(provider.getName());
        }
    }

    public static void setDefaultJSSEProvider(@NotNull Provider defaultJSSEProvider) {
        Validator.ensureNotNull(defaultJSSEProvider);
        DEFAULT_JSSE_PROVIDER.set(defaultJSSEProvider);
        if (CryptoHelper.usingFIPSMode()) {
            Security.insertProviderAt(defaultJSSEProvider, 2);
        } else {
            Security.insertProviderAt(defaultJSSEProvider, 1);
        }
        TLSCipherSuiteSelector.recompute();
    }

    @NotNull
    public static CertificateFactory getCertificateFactory(@NotNull String type) throws CertificateException {
        return CryptoHelper.getCertificateFactory(type, NULL_PROVIDER);
    }

    @NotNull
    public static CertificateFactory getCertificateFactory(@NotNull String type, @Nullable String providerName) throws CertificateException, NoSuchProviderException {
        return CryptoHelper.getCertificateFactory(type, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static CertificateFactory getCertificateFactory(@NotNull String type, @Nullable Provider provider) throws CertificateException {
        String providerClass;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                return CertificateFactory.getInstance(type, FIPS_PROVIDER.get());
            }
            return CertificateFactory.getInstance(type);
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new CertificateException(UtilityMessages.ERR_CRYPTO_HELPER_GET_CERT_FACTORY_WRONG_PROVIDER_FOR_FIPS_MODE.get(type, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return CertificateFactory.getInstance(type, provider);
    }

    @NotNull
    public static Cipher getCipher(@NotNull String cipherTransformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return CryptoHelper.getCipher(cipherTransformation, NULL_PROVIDER);
    }

    @NotNull
    public static Cipher getCipher(@NotNull String cipherTransformation, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        return CryptoHelper.getCipher(cipherTransformation, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static Cipher getCipher(@NotNull String cipherTransformation, @Nullable Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String providerClass;
        String transformation = cipherTransformation.equalsIgnoreCase("AES/GCM/PKCS5Padding") ? "AES/GCM/NoPadding" : cipherTransformation;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                return Cipher.getInstance(transformation, FIPS_PROVIDER.get());
            }
            return Cipher.getInstance(transformation);
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_CIPHER_WRONG_PROVIDER_FOR_FIPS_MODE.get(transformation, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return Cipher.getInstance(transformation, provider);
    }

    @NotNull
    public static KeyFactory getKeyFactory(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getKeyFactory(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static KeyFactory getKeyFactory(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getKeyFactory(algorithmName, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static KeyFactory getKeyFactory(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerClass;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                return KeyFactory.getInstance(algorithmName, FIPS_PROVIDER.get());
            }
            return KeyFactory.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_KEY_FACTORY_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return KeyFactory.getInstance(algorithmName, provider);
    }

    @NotNull
    public static KeyManagerFactory getKeyManagerFactory() throws NoSuchAlgorithmException {
        Provider defaultJSSEProvider = DEFAULT_JSSE_PROVIDER.get();
        if (defaultJSSEProvider != null) {
            NoSuchAlgorithmException noSuchAlgorithmException = null;
            String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            try {
                return KeyManagerFactory.getInstance(defaultAlgorithm, defaultJSSEProvider);
            }
            catch (NoSuchAlgorithmException e) {
                Debug.debugException(e);
                noSuchAlgorithmException = e;
                String fipsDefaultAlgorithm = FIPS_DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM.get();
                if (fipsDefaultAlgorithm != null) {
                    try {
                        return KeyManagerFactory.getInstance(fipsDefaultAlgorithm, defaultJSSEProvider);
                    }
                    catch (Exception e2) {
                        Debug.debugException(e2);
                    }
                }
                for (Provider.Service service : defaultJSSEProvider.getServices()) {
                    if (!service.getType().equalsIgnoreCase("KeyManagerFactory")) continue;
                    return KeyManagerFactory.getInstance(service.getAlgorithm(), defaultJSSEProvider);
                }
                throw noSuchAlgorithmException;
            }
        }
        if (CryptoHelper.usingFIPSMode()) {
            return KeyManagerFactory.getInstance(FIPS_DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM.get(), FIPS_JSSE_PROVIDER.get());
        }
        return CryptoHelper.getKeyManagerFactory(KeyManagerFactory.getDefaultAlgorithm());
    }

    @NotNull
    public static KeyManagerFactory getKeyManagerFactory(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getKeyManagerFactory(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static KeyManagerFactory getKeyManagerFactory(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getKeyManagerFactory(algorithmName, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static KeyManagerFactory getKeyManagerFactory(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerClass;
        if (provider == null) {
            Provider defaultJSSEProvider = DEFAULT_JSSE_PROVIDER.get();
            if (defaultJSSEProvider != null) {
                return KeyManagerFactory.getInstance(algorithmName, defaultJSSEProvider);
            }
            if (CryptoHelper.usingFIPSMode()) {
                return KeyManagerFactory.getInstance(algorithmName, FIPS_PROVIDER.get());
            }
            return KeyManagerFactory.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_KM_FACTORY_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return KeyManagerFactory.getInstance(algorithmName, provider);
    }

    @NotNull
    public static KeyPairGenerator getKeyPairGenerator(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getKeyPairGenerator(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static KeyPairGenerator getKeyPairGenerator(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getKeyPairGenerator(algorithmName, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static KeyPairGenerator getKeyPairGenerator(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerClass;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                return KeyPairGenerator.getInstance(algorithmName, FIPS_PROVIDER.get());
            }
            return KeyPairGenerator.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_KP_GEN_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return KeyPairGenerator.getInstance(algorithmName, provider);
    }

    @NotNull
    public static String getDefaultKeyStoreType() {
        return DEFAULT_KEY_STORE_TYPE.get();
    }

    public static void setDefaultKeyStoreType(@NotNull String defaultKeyStoreType) {
        DEFAULT_KEY_STORE_TYPE.set(defaultKeyStoreType);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public static String inferKeyStoreType(@NotNull File keyStoreFile) throws KeyStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public static KeyStore getKeyStore(@NotNull String keyStoreType) throws KeyStoreException {
        return CryptoHelper.getKeyStore(keyStoreType, NULL_PROVIDER);
    }

    @NotNull
    public static KeyStore getKeyStore(@NotNull String keyStoreType, @Nullable String providerName) throws KeyStoreException, NoSuchProviderException {
        return CryptoHelper.getKeyStore(keyStoreType, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static KeyStore getKeyStore(@NotNull String keyStoreType, @Nullable Provider provider) throws KeyStoreException {
        return CryptoHelper.getKeyStore(keyStoreType, provider, false);
    }

    @NotNull
    public static KeyStore getKeyStore(@NotNull String keyStoreType, @Nullable Provider provider, boolean allowNonFIPSInFIPSMode) throws KeyStoreException {
        if (CryptoHelper.usingFIPSMode() && !allowNonFIPSInFIPSMode) {
            String providerClass;
            if (!keyStoreType.equals(KEY_STORE_TYPE_BCFKS) && !keyStoreType.equals(KEY_STORE_TYPE_PKCS_11)) {
                throw new KeyStoreException(UtilityMessages.ERR_CRYPTO_HELPER_GET_KEY_STORE_WRONG_STORE_TYPE_FOR_FIPS_MODE.get(keyStoreType, KEY_STORE_TYPE_BCFKS, KEY_STORE_TYPE_PKCS_11));
            }
            if (provider != null && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
                throw new KeyStoreException(UtilityMessages.ERR_CRYPTO_HELPER_GET_KEY_STORE_WRONG_PROVIDER_FOR_FIPS_MODE.get(keyStoreType, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
            }
        }
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode() && keyStoreType.equals(FIPS_DEFAULT_KEY_STORE_TYPE.get())) {
                return KeyStore.getInstance(keyStoreType, FIPS_PROVIDER.get());
            }
            return KeyStore.getInstance(keyStoreType);
        }
        if (keyStoreType.equals(KEY_STORE_TYPE_BCFKS) && !provider.getName().equals("BCFIPS")) {
            throw new KeyStoreException(UtilityMessages.ERR_CRYPTO_HELPER_GET_KEY_STORE_WRONG_PROVIDER_FOR_STORE_TYPE.get(keyStoreType, provider.getName(), KEY_STORE_TYPE_BCFKS, keyStoreType));
        }
        return KeyStore.getInstance(keyStoreType, provider);
    }

    @NotNull
    public static Mac getMAC(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getMAC(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static Mac getMAC(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getMAC(algorithmName, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static Mac getMAC(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerClass;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                return Mac.getInstance(algorithmName, FIPS_PROVIDER.get());
            }
            return Mac.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_MAC_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return Mac.getInstance(algorithmName, provider);
    }

    @NotNull
    public static MessageDigest getMessageDigest(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getMessageDigest(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static MessageDigest getMessageDigest(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getMessageDigest(algorithmName, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static MessageDigest getMessageDigest(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerClass;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                return MessageDigest.getInstance(algorithmName, FIPS_PROVIDER.get());
            }
            return MessageDigest.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_DIGEST_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return MessageDigest.getInstance(algorithmName, provider);
    }

    @NotNull
    public static SecretKeyFactory getSecretKeyFactory(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getSecretKeyFactory(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static SecretKeyFactory getSecretKeyFactory(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getSecretKeyFactory(algorithmName, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static SecretKeyFactory getSecretKeyFactory(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerClass;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                return SecretKeyFactory.getInstance(algorithmName, FIPS_PROVIDER.get());
            }
            return SecretKeyFactory.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_SK_FACTORY_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return SecretKeyFactory.getInstance(algorithmName, provider);
    }

    @NotNull
    public static SecureRandom getSecureRandom() {
        try {
            return CryptoHelper.getSecureRandom(null, NULL_PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            Debug.debugException(e);
            throw new LDAPRuntimeException(new LDAPException(ResultCode.LOCAL_ERROR, e.getMessage(), e));
        }
    }

    @NotNull
    public static SecureRandom getSecureRandom(@Nullable String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getSecureRandom(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static SecureRandom getSecureRandom(@Nullable String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getSecureRandom(algorithmName, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static SecureRandom getSecureRandom(@Nullable String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerClass;
        if (algorithmName == null) {
            if (provider == null) {
                if (CryptoHelper.usingFIPSMode()) {
                    return CryptoHelper.getSecureRandom(FIPS_PROVIDER.get());
                }
                return new SecureRandom();
            }
            return CryptoHelper.getSecureRandom(provider);
        }
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                return CryptoHelper.getSecureRandom(algorithmName, FIPS_PROVIDER.get());
            }
            return SecureRandom.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_SEC_RAND_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return SecureRandom.getInstance(algorithmName, provider);
    }

    @NotNull
    private static SecureRandom getSecureRandom(@NotNull Provider provider) throws NoSuchAlgorithmException {
        String providerName;
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals(FIPS_PROVIDER.get().getName())) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_SEC_RAND_WRONG_PROVIDER_FOR_FIPS_MODE_NO_ALG.get(providerName, FIPS_PROVIDER.get().getName()));
        }
        for (Provider.Service service : provider.getServices()) {
            if (!service.getType().equals(SECURE_RANDOM_SERVICE_TYPE)) continue;
            return SecureRandom.getInstance(service.getAlgorithm(), provider);
        }
        throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_SEC_RAND_NO_ALG_FOR_PROVIDER.get(provider.getName()));
    }

    @NotNull
    public static Signature getSignature(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getSignature(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static Signature getSignature(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getSignature(algorithmName, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static Signature getSignature(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerClass;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                return Signature.getInstance(algorithmName, FIPS_PROVIDER.get());
            }
            return Signature.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_SIGNATURE_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return Signature.getInstance(algorithmName, provider);
    }

    @NotNull
    public static SSLContext getDefaultSSLContext() throws NoSuchAlgorithmException {
        Provider defaultJSSEProvider = DEFAULT_JSSE_PROVIDER.get();
        if (defaultJSSEProvider != null) {
            SSLContext defaultContext = SSLContext.getDefault();
            if (defaultContext.getProvider().equals(defaultJSSEProvider)) {
                return defaultContext;
            }
            for (Provider.Service service : defaultJSSEProvider.getServices()) {
                if (!service.getType().equalsIgnoreCase("SSLContext") || !service.getAlgorithm().equalsIgnoreCase("default")) continue;
                return SSLContext.getInstance(service.getAlgorithm(), defaultJSSEProvider);
            }
        }
        if (CryptoHelper.usingFIPSMode()) {
            try {
                return SSLContext.getInstance(FIPS_DEFAULT_SSL_CONTEXT_PROTOCOL.get(), FIPS_JSSE_PROVIDER.get());
            }
            catch (NoSuchAlgorithmException e) {
                Debug.debugException(e);
                for (String protocol : FIPS_ALTERNATIVE_DEFAULT_SSL_CONTEXT_PROTOCOLS.get()) {
                    try {
                        SSLContext context = SSLContext.getInstance(protocol, FIPS_JSSE_PROVIDER.get());
                        TrustManager[] defaultTrustManagers = new TrustManager[]{JVMDefaultTrustManager.getInstance()};
                        context.init(null, defaultTrustManagers, CryptoHelper.getSecureRandom());
                        return context;
                    }
                    catch (Exception e2) {
                        Debug.debugException(e2);
                    }
                }
                throw e;
            }
        }
        return SSLContext.getDefault();
    }

    @NotNull
    public static SSLContext getSSLContext(@NotNull String protocol) throws NoSuchAlgorithmException {
        return CryptoHelper.getSSLContext(protocol, NULL_PROVIDER);
    }

    @NotNull
    public static SSLContext getSSLContext(@NotNull String protocol, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getSSLContext(protocol, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static SSLContext getSSLContext(@NotNull String protocol, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerClass;
        if (provider == null) {
            Provider defaultJSSEProvider = DEFAULT_JSSE_PROVIDER.get();
            if (defaultJSSEProvider != null) {
                return SSLContext.getInstance(protocol, defaultJSSEProvider);
            }
            if (CryptoHelper.usingFIPSMode()) {
                return SSLContext.getInstance(protocol, FIPS_JSSE_PROVIDER.get());
            }
            return SSLContext.getInstance(protocol);
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_SSL_CONTEXT_WRONG_PROVIDER_FOR_FIPS_MODE.get(protocol, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return SSLContext.getInstance(protocol, provider);
    }

    @NotNull
    public static TrustManagerFactory getTrustManagerFactory() throws NoSuchAlgorithmException {
        Provider defaultJSSEProvider = DEFAULT_JSSE_PROVIDER.get();
        if (defaultJSSEProvider != null) {
            NoSuchAlgorithmException noSuchAlgorithmException = null;
            String defaultAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            try {
                return TrustManagerFactory.getInstance(defaultAlgorithm, defaultJSSEProvider);
            }
            catch (NoSuchAlgorithmException e) {
                Debug.debugException(e);
                noSuchAlgorithmException = e;
                String fipsDefaultAlgorithm = FIPS_DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM.get();
                if (fipsDefaultAlgorithm != null) {
                    try {
                        return TrustManagerFactory.getInstance(fipsDefaultAlgorithm, defaultJSSEProvider);
                    }
                    catch (Exception e2) {
                        Debug.debugException(e2);
                    }
                }
                for (Provider.Service service : defaultJSSEProvider.getServices()) {
                    if (!service.getType().equalsIgnoreCase("TrustManagerFactory")) continue;
                    return TrustManagerFactory.getInstance(service.getAlgorithm(), defaultJSSEProvider);
                }
                throw noSuchAlgorithmException;
            }
        }
        if (CryptoHelper.usingFIPSMode()) {
            return TrustManagerFactory.getInstance(FIPS_DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM.get(), FIPS_JSSE_PROVIDER.get());
        }
        return CryptoHelper.getTrustManagerFactory(TrustManagerFactory.getDefaultAlgorithm());
    }

    @NotNull
    public static TrustManagerFactory getTrustManagerFactory(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getTrustManagerFactory(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static TrustManagerFactory getTrustManagerFactory(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getTrustManagerFactory(algorithmName, CryptoHelper.getProvider(providerName));
    }

    @NotNull
    public static TrustManagerFactory getTrustManagerFactory(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerClass;
        if (provider == null) {
            Provider defaultJSSEProvider = DEFAULT_JSSE_PROVIDER.get();
            if (defaultJSSEProvider != null) {
                return TrustManagerFactory.getInstance(algorithmName, defaultJSSEProvider);
            }
            if (CryptoHelper.usingFIPSMode()) {
                return TrustManagerFactory.getInstance(algorithmName, FIPS_PROVIDER.get());
            }
            return TrustManagerFactory.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_TM_FACTORY_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return TrustManagerFactory.getInstance(algorithmName, provider);
    }

    @NotNull
    public static UUID getRandomUUID() {
        if (CryptoHelper.usingFIPSMode()) {
            byte[] uuidBytes = new byte[16];
            ThreadLocalSecureRandom.get().nextBytes(uuidBytes);
            uuidBytes[6] = (byte)(uuidBytes[6] & 0xF | 0x40);
            uuidBytes[8] = (byte)(uuidBytes[8] & 0x3F | 0x80);
            return CryptoHelper.uuidFromBytes(uuidBytes);
        }
        return UUID.randomUUID();
    }

    @NotNull
    public static UUID getNameUUIDFromBytes(@NotNull byte[] name) {
        if (CryptoHelper.usingFIPSMode()) {
            try {
                MessageDigest sha256 = CryptoHelper.getMessageDigest("SHA-256");
                byte[] digestBytes = sha256.digest(name);
                digestBytes[6] = (byte)(digestBytes[6] & 0xF | 0x30);
                digestBytes[8] = (byte)(digestBytes[8] & 0x3F | 0x80);
                return CryptoHelper.uuidFromBytes(digestBytes);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new RuntimeException(e);
            }
        }
        return UUID.nameUUIDFromBytes(name);
    }

    @NotNull
    private static UUID uuidFromBytes(@NotNull byte[] uuidBytes) {
        long mostSignificantBits = ((long)uuidBytes[0] & 0xFFL) << 56 | ((long)uuidBytes[1] & 0xFFL) << 48 | ((long)uuidBytes[2] & 0xFFL) << 40 | ((long)uuidBytes[3] & 0xFFL) << 32 | ((long)uuidBytes[4] & 0xFFL) << 24 | ((long)uuidBytes[5] & 0xFFL) << 16 | ((long)uuidBytes[6] & 0xFFL) << 8 | (long)uuidBytes[7] & 0xFFL;
        long leastSignificantBits = ((long)uuidBytes[8] & 0xFFL) << 56 | ((long)uuidBytes[9] & 0xFFL) << 48 | ((long)uuidBytes[10] & 0xFFL) << 40 | ((long)uuidBytes[11] & 0xFFL) << 32 | ((long)uuidBytes[12] & 0xFFL) << 24 | ((long)uuidBytes[13] & 0xFFL) << 16 | ((long)uuidBytes[14] & 0xFFL) << 8 | (long)uuidBytes[15] & 0xFFL;
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    @Nullable
    private static Provider getProvider(@Nullable String providerName) throws NoSuchProviderException {
        String providerClass;
        if (providerName == null) {
            return null;
        }
        if (providerName.equals("BCFIPS")) {
            return BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider();
        }
        if (providerName.equals("BCJSSE")) {
            return BouncyCastleFIPSHelper.getBouncyCastleJSSEProvider();
        }
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(UtilityMessages.ERR_CRYPTO_HELPER_NO_SUCH_PROVIDER.get(providerName));
        }
        if (CryptoHelper.usingFIPSMode() && !ALLOWED_FIPS_MODE_PROVIDERS.contains(providerClass = provider.getClass().getName())) {
            throw new NoSuchProviderException(UtilityMessages.ERR_CRYPTO_HELPER_PROVIDER_NOT_AVAILABLE_IN_FIPS_MODE.get(providerClass, StaticUtils.concatenateStrings(new ArrayList<String>(ALLOWED_FIPS_MODE_PROVIDERS))));
        }
        return provider;
    }

    @NotNull
    public static byte[] digest(@NotNull String digestAlgorithm, @NotNull byte[] dataToDigest) throws NoSuchAlgorithmException {
        MessageDigest digest = CryptoHelper.getMessageDigest(digestAlgorithm);
        return digest.digest(dataToDigest);
    }

    @NotNull
    public static byte[] digest(@NotNull String digestAlgorithm, @NotNull String dataToDigest) throws NoSuchAlgorithmException {
        MessageDigest digest = CryptoHelper.getMessageDigest(digestAlgorithm);
        return digest.digest(StaticUtils.getBytes(dataToDigest));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static byte[] digest(@NotNull String digestAlgorithm, @NotNull File fileToDigest) throws NoSuchAlgorithmException, IOException {
        try (FileInputStream inputStream = new FileInputStream(fileToDigest);){
            MessageDigest digest = CryptoHelper.getMessageDigest(digestAlgorithm);
            byte[] buffer = new byte[0x100000];
            while (true) {
                int bytesRead;
                if ((bytesRead = inputStream.read(buffer)) < 0) {
                    byte[] byArray = digest.digest();
                    return byArray;
                }
                digest.update(buffer, 0, bytesRead);
                continue;
                break;
            }
        }
    }

    @NotNull
    public static byte[] sha256(@NotNull byte[] dataToDigest) throws NoSuchAlgorithmException {
        return CryptoHelper.digest("SHA-256", dataToDigest);
    }

    @NotNull
    public static byte[] sha256(@NotNull String dataToDigest) throws NoSuchAlgorithmException {
        return CryptoHelper.digest("SHA-256", dataToDigest);
    }

    @NotNull
    public static byte[] sha256(@NotNull File fileToDigest) throws NoSuchAlgorithmException, IOException {
        return CryptoHelper.digest("SHA-256", fileToDigest);
    }

    @NotNull
    public static byte[] sha384(@NotNull byte[] dataToDigest) throws NoSuchAlgorithmException {
        return CryptoHelper.digest("SHA-384", dataToDigest);
    }

    @NotNull
    public static byte[] sha384(@NotNull String dataToDigest) throws NoSuchAlgorithmException {
        return CryptoHelper.digest("SHA-384", dataToDigest);
    }

    @NotNull
    public static byte[] sha384(@NotNull File fileToDigest) throws NoSuchAlgorithmException, IOException {
        return CryptoHelper.digest("SHA-384", fileToDigest);
    }

    @NotNull
    public static byte[] sha512(@NotNull byte[] dataToDigest) throws NoSuchAlgorithmException {
        return CryptoHelper.digest("SHA-512", dataToDigest);
    }

    @NotNull
    public static byte[] sha512(@NotNull String dataToDigest) throws NoSuchAlgorithmException {
        return CryptoHelper.digest("SHA-512", dataToDigest);
    }

    @NotNull
    public static byte[] sha512(@NotNull File fileToDigest) throws NoSuchAlgorithmException, IOException {
        return CryptoHelper.digest("SHA-512", fileToDigest);
    }

    static {
        String fipsModePropertyValue;
        ALLOWED_FIPS_MODE_PROVIDERS = new CopyOnWriteArraySet<String>();
        FIPS_PROVIDER = new AtomicReference();
        FIPS_JSSE_PROVIDER = new AtomicReference();
        FIPS_DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM = new AtomicReference();
        FIPS_DEFAULT_KEY_STORE_TYPE = new AtomicReference();
        FIPS_DEFAULT_SSL_CONTEXT_PROTOCOL = new AtomicReference();
        FIPS_ALTERNATIVE_DEFAULT_SSL_CONTEXT_PROTOCOLS = new AtomicReference();
        FIPS_DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM = new AtomicReference();
        FIPS_PROVIDER_NAME = new AtomicReference();
        ALLOWED_FIPS_MODE_PROVIDERS.addAll(StaticUtils.setOf("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider", "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", "com.sun.net.ssl.internal.ssl.Provider", "sun.security.provider.Sun", "sun.security.jgss.SunProvider", "com.sun.security.sasl.Provider", "sun.security.provider.certpath.ldap.JdkLDAP", "com.sun.security.sasl.gsskerb.JdkSASL", "sun.security.pkcs11.SunPKCS11", "com.ibm.security.jgss.IBMJGSSProvider", "com.ibm.security.sasl.IBMSASL"));
        String preserveProviderPropertyValue = PropertyManager.get(PROPERTY_ALLOWED_FIPS_MODE_PROVIDER);
        if (preserveProviderPropertyValue != null) {
            StringTokenizer tokenizer = new StringTokenizer(preserveProviderPropertyValue, ",");
            while (tokenizer.hasMoreTokens()) {
                String className = tokenizer.nextToken().trim();
                if (className.isEmpty()) continue;
                ALLOWED_FIPS_MODE_PROVIDERS.add(className);
            }
        }
        if ((fipsModePropertyValue = PropertyManager.get(PROPERTY_FIPS_MODE)) == null || fipsModePropertyValue.equalsIgnoreCase("false")) {
            FIPS_MODE = new AtomicBoolean(false);
            FIPS_PROVIDER_NAME.set(null);
        } else if (fipsModePropertyValue.equalsIgnoreCase("true")) {
            String fipsProviderVersionString;
            String fipsProviderPropertyValue = PropertyManager.get(PROPERTY_FIPS_PROVIDER);
            if (fipsProviderPropertyValue == null || fipsProviderPropertyValue.equalsIgnoreCase("BCFIPS")) {
                fipsProviderVersionString = null;
                FIPS_PROVIDER_NAME.set("BCFIPS");
            } else if (fipsProviderPropertyValue.equalsIgnoreCase("BCFIPS1")) {
                fipsProviderVersionString = "1";
                FIPS_PROVIDER_NAME.set("BCFIPS1");
            } else if (fipsProviderPropertyValue.equalsIgnoreCase("BCFIPS2")) {
                fipsProviderVersionString = "2";
                FIPS_PROVIDER_NAME.set("BCFIPS2");
            } else {
                fipsProviderVersionString = null;
                FIPS_PROVIDER_NAME.set(null);
                Validator.violation(UtilityMessages.ERR_CRYPTO_HELPER_UNSUPPORTED_FIPS_PROVIDER.get(fipsProviderPropertyValue, "BCFIPS"));
            }
            FIPS_MODE = new AtomicBoolean(true);
            try {
                BouncyCastleFIPSHelper.setPropertiesForPingIdentityServer();
                FIPS_PROVIDER.set(BouncyCastleFIPSHelper.loadBouncyCastleFIPSProvider(true, fipsProviderVersionString));
                FIPS_JSSE_PROVIDER.set(BouncyCastleFIPSHelper.loadBouncyCastleJSSEProvider(true, fipsProviderVersionString));
                FIPS_DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM.set("X.509");
                FIPS_DEFAULT_KEY_STORE_TYPE.set(KEY_STORE_TYPE_BCFKS);
                FIPS_DEFAULT_SSL_CONTEXT_PROTOCOL.set("DEFAULT");
                FIPS_ALTERNATIVE_DEFAULT_SSL_CONTEXT_PROTOCOLS.set(BouncyCastleFIPSHelper.ALTERNATIVE_DEFAULT_SSL_CONTEXT_PROTOCOLS);
                FIPS_DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM.set("PKIX");
                String prunePropertyValue = PropertyManager.get(PROPERTY_REMOVE_NON_NECESSARY_PROVIDERS);
                if (prunePropertyValue != null) {
                    if (prunePropertyValue.equalsIgnoreCase("true")) {
                        CryptoHelper.removeNonEssentialSecurityProviders();
                    } else if (!prunePropertyValue.equalsIgnoreCase("false")) {
                        Validator.violation(UtilityMessages.ERR_CRYPTO_HELPER_INVALID_FIPS_MODE_PROPERTY_VALUE.get(PROPERTY_REMOVE_NON_NECESSARY_PROVIDERS, prunePropertyValue));
                    }
                }
                TLSCipherSuiteSelector.recompute();
            }
            catch (Exception e) {
                Validator.violation(UtilityMessages.ERR_CRYPTO_HELPER_INSTANTIATION_ERROR_FROM_FIPS_MODE_PROPERTY.get(PROPERTY_FIPS_MODE, StaticUtils.getExceptionMessage(e)), e);
                FIPS_MODE.set(false);
                FIPS_PROVIDER_NAME.set(null);
            }
        } else {
            FIPS_MODE = new AtomicBoolean(false);
            FIPS_PROVIDER_NAME.set(null);
            Validator.violation(UtilityMessages.ERR_CRYPTO_HELPER_INVALID_FIPS_MODE_PROPERTY_VALUE.get(PROPERTY_FIPS_MODE, fipsModePropertyValue));
        }
        DEFAULT_JSSE_PROVIDER = new AtomicReference();
        String propertyValue = PropertyManager.get(PROPERTY_DEFAULT_KEY_STORE_TYPE);
        String defaultKeyStoreType = propertyValue == null ? (FIPS_MODE.get() ? KEY_STORE_TYPE_BCFKS : KeyStore.getDefaultType()) : propertyValue;
        DEFAULT_KEY_STORE_TYPE = new AtomicReference<String>(defaultKeyStoreType);
        NULL_PROVIDER = null;
    }
}

