/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.catalog.api.Attribute;
import org.apache.logging.log4j.catalog.api.CatalogData;
import org.apache.logging.log4j.catalog.api.Category;
import org.apache.logging.log4j.catalog.api.Event;
import org.apache.logging.log4j.catalog.api.Product;
import org.apache.logging.log4j.catalog.api.plugins.ConstraintPlugins;
import org.apache.logging.log4j.catalog.jpa.converter.AttributeModelConverter;
import org.apache.logging.log4j.catalog.jpa.converter.CategoryModelConverter;
import org.apache.logging.log4j.catalog.jpa.converter.EventModelConverter;
import org.apache.logging.log4j.catalog.jpa.converter.ProductModelConverter;
import org.apache.logging.log4j.catalog.jpa.dao.AttributeRepository;
import org.apache.logging.log4j.catalog.jpa.dao.CatalogRepository;
import org.apache.logging.log4j.catalog.jpa.dao.CategoryRepository;
import org.apache.logging.log4j.catalog.jpa.dao.EventRepository;
import org.apache.logging.log4j.catalog.jpa.dao.ProductRepository;
import org.apache.logging.log4j.catalog.jpa.model.AttributeModel;
import org.apache.logging.log4j.catalog.jpa.model.CatalogModel;
import org.apache.logging.log4j.catalog.jpa.model.CategoryModel;
import org.apache.logging.log4j.catalog.jpa.model.EventModel;
import org.apache.logging.log4j.catalog.jpa.model.ProductModel;
import org.apache.logging.log4j.catalog.jpa.service.CatalogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Repository
@Transactional(readOnly=false)
public class CatalogServiceImpl
implements CatalogService {
    private static final ConstraintPlugins constraintPlugins = ConstraintPlugins.getInstance();
    @Autowired
    private AttributeRepository attributeRepository;
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    private AttributeModelConverter attributeModelConverter;
    @Autowired
    private EventModelConverter eventModelConverter;
    @Autowired
    private CategoryModelConverter categoryModelConverter;
    @Autowired
    private ProductModelConverter productModelConverter;
    @Autowired
    private CatalogRepository catalogRepository;

    @Override
    public CatalogData getCatalogData() {
        CatalogData data = new CatalogData();
        List modelAttributes = this.attributeRepository.findAll();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(modelAttributes.size());
        for (AttributeModel modelAttribute : modelAttributes) {
            Attribute attribute = this.attributeModelConverter.convert(modelAttribute);
            attributes.add(attribute);
        }
        data.setAttributes(attributes);
        List modelEvents = this.eventRepository.findAll();
        ArrayList<Event> events = new ArrayList<Event>(modelEvents.size());
        for (EventModel modelEvent : modelEvents) {
            Event event = this.eventModelConverter.convert(modelEvent);
            events.add(event);
        }
        data.setEvents(events);
        List modelCategories = this.categoryRepository.findAll();
        ArrayList<Category> categories = new ArrayList<Category>(modelCategories.size());
        for (CategoryModel modelCategory : modelCategories) {
            Category category = this.categoryModelConverter.convert(modelCategory);
            categories.add(category);
        }
        data.setCategories(categories);
        List modelProducts = this.productRepository.findAll();
        ArrayList<Product> products = new ArrayList<Product>(modelProducts.size());
        for (ProductModel modelProduct : modelProducts) {
            Product product = this.productModelConverter.convert(modelProduct);
            products.add(product);
        }
        data.setProducts(products);
        return data;
    }

    public List<CategoryModel> getCategories() {
        return this.categoryRepository.findAll();
    }

    public Optional<CategoryModel> getCategory(String name) {
        return this.categoryRepository.findByName(name);
    }

    public Optional<CategoryModel> getCategory(long id) {
        return this.categoryRepository.findOne(id);
    }

    @Override
    public CatalogModel getCatalogModel() {
        List catalogModels = this.catalogRepository.findAll();
        if (catalogModels != null && catalogModels.size() > 0) {
            return (CatalogModel)catalogModels.get(0);
        }
        return null;
    }

    @Override
    public void saveCatalog(CatalogModel catalogModel) {
        this.catalogRepository.save(catalogModel);
    }
}

