/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.service;

import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.jpa.dao.CategoryRepository;
import org.apache.logging.log4j.catalog.jpa.model.CategoryModel;
import org.apache.logging.log4j.catalog.jpa.service.AbstractPagingAndSortingService;
import org.apache.logging.log4j.catalog.jpa.service.CategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Repository
@Transactional
public class CategoryServiceImpl
extends AbstractPagingAndSortingService
implements CategoryService {
    private static final Logger LOGGER = LogManager.getLogger();
    @Autowired
    private CategoryRepository categoryRepository;

    @Override
    public List<CategoryModel> getCategories() {
        return this.categoryRepository.findAll();
    }

    @Override
    public List<CategoryModel> getCategories(String catalogId) {
        return this.categoryRepository.findByCatalogId(catalogId);
    }

    @Override
    public List<CategoryModel> getCategories(int startPage, int itemsPerPage, String sortColumn, String direction) {
        Pageable pageable = this.createPageRequest(startPage, itemsPerPage, sortColumn, direction);
        Page page = this.categoryRepository.findAll(pageable);
        return page.getContent();
    }

    @Override
    public List<CategoryModel> getCategories(String catalogId, int startPage, int itemsPerPage, String sortColumn, String direction) {
        Pageable pageable = this.createPageRequest(startPage, itemsPerPage, sortColumn, direction);
        Page page = this.categoryRepository.findByCatalogId(catalogId, pageable);
        return page.getContent();
    }

    @Override
    public Optional<CategoryModel> getCategory(Long categoryId) {
        return this.categoryRepository.findOne(categoryId);
    }

    @Override
    public Optional<CategoryModel> getCategory(String catalogId, String name) {
        return this.categoryRepository.findByCatalogIdAndName(catalogId, name);
    }

    @Override
    public CategoryModel saveCategory(CategoryModel category) {
        return this.categoryRepository.save(category);
    }

    @Override
    public void deleteCategory(Long categoryId) {
        this.categoryRepository.deleteById(categoryId);
    }
}

