/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api;

public enum DataType {
    STRING("String", null),
    BIG_DECIMAL("BigDecimal", "java.math.BigDecimal"),
    DOUBLE("double", null),
    FLOAT("float", null),
    INT("int", null),
    LONG("long", null),
    BOOLEAN("boolean", null),
    LIST("List<String>", "java.util.List"),
    MAP("Map<String, String>", "java.util.Map");

    private final String typeName;
    public final String importClass;

    private DataType(String typeName, String importClass) {
        this.typeName = typeName;
        this.importClass = importClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getImportClass() {
        return this.importClass;
    }

    public static DataType fromName(String typeName) {
        for (DataType dataType : DataType.values()) {
            if (!dataType.typeName.equalsIgnoreCase(typeName)) continue;
            return dataType;
        }
        throw new IllegalArgumentException("Unknown data type: " + typeName);
    }
}

