/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.recycler.internal;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.stream.IntStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.logging.log4j.util.InternalApi;

@InternalApi
@NotThreadSafe
final class ArrayQueue<E>
extends AbstractQueue<E> {
    private final E[] buffer;
    private int head;
    private int tail;
    private int size;

    ArrayQueue(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("invalid capacity: " + capacity);
        }
        this.buffer = new Object[capacity];
        this.head = 0;
        this.tail = -1;
        this.size = 0;
    }

    @Override
    public Iterator<E> iterator() {
        int[] i = new int[]{this.head};
        return IntStream.range(0, this.size).mapToObj(ignored -> {
            E item = this.buffer[i[0]];
            i[0] = (i[0] + 1) % this.buffer.length;
            return item;
        }).iterator();
    }

    @Override
    public boolean offer(E item) {
        if (this.size == this.buffer.length) {
            return false;
        }
        this.tail = (this.tail + 1) % this.buffer.length;
        this.buffer[this.tail] = item;
        ++this.size;
        return true;
    }

    @Override
    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        E item = this.buffer[this.head];
        this.buffer[this.head] = null;
        this.head = (this.head + 1) % this.buffer.length;
        --this.size;
        return item;
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.buffer[this.head];
    }

    @Override
    public int size() {
        return this.size;
    }
}

