/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.InternationalString;

public final class Resources
extends IndexedResourceBundle {
    public Resources(URL uRL) {
        super(uRL);
    }

    @Override
    protected KeyConstants getKeyConstants() {
        return Keys.INSTANCE;
    }

    public static Resources forLocale(Locale locale) throws MissingResourceException {
        return Resources.getBundle(Resources.class, locale);
    }

    public static Resources forProperties(Map<?, ?> map) throws MissingResourceException {
        return Resources.forLocale(Resources.getLocale(map));
    }

    public static String format(short s) throws MissingResourceException {
        return Resources.forLocale(null).getString(s);
    }

    public static String format(short s, Object object) throws MissingResourceException {
        return Resources.forLocale(null).getString(s, object);
    }

    public static String format(short s, Object object, Object object2) throws MissingResourceException {
        return Resources.forLocale(null).getString(s, object, object2);
    }

    public static String format(short s, Object object, Object object2, Object object3) throws MissingResourceException {
        return Resources.forLocale(null).getString(s, object, object2, object3);
    }

    public static String format(short s, Object object, Object object2, Object object3, Object object4) throws MissingResourceException {
        return Resources.forLocale(null).getString(s, object, object2, object3, object4);
    }

    public static InternationalString formatInternational(short s) {
        return new International(s);
    }

    public static InternationalString formatInternational(short s, Object object) {
        return new International(s, object);
    }

    public static InternationalString formatInternational(short s, Object ... objectArray) {
        return new International(s, objectArray);
    }

    public static final class Keys
    extends KeyConstants {
        static final Keys INSTANCE = new Keys();
        public static final short AmbiguousEllipsoid_1 = 1;
        public static final short AzimuthAndDistanceNotSet = 87;
        public static final short CanNotAssociateToCS_2 = 95;
        public static final short CanNotCombineUriAsType_1 = 79;
        public static final short CanNotComputeDerivative = 2;
        public static final short CanNotConcatenateTransforms_2 = 3;
        public static final short CanNotConvertCoordinates_2 = 89;
        public static final short CanNotCreateObjectAsInstanceOf_2 = 4;
        public static final short CanNotFindCommonCRS = 82;
        public static final short CanNotInferGridSizeFromValues_1 = 75;
        public static final short CanNotInstantiateGeodeticObject_1 = 5;
        public static final short CanNotMapAxisToDirection_1 = 6;
        public static final short CanNotParseCombinedReference_2 = 78;
        public static final short CanNotParseWKT_2 = 96;
        public static final short CanNotSeparateCRS_1 = 84;
        public static final short CanNotSeparateTargetDimension_1 = 7;
        public static final short CanNotSeparateTransform_3 = 83;
        public static final short CanNotTransformCoordinates_2 = 85;
        public static final short CanNotTransformEnvelopeToGeodetic = 8;
        public static final short CanNotTransformGeometry = 86;
        public static final short CanNotUseGeodeticParameters_2 = 9;
        public static final short ColinearAxisDirections_2 = 10;
        public static final short ConformanceMeansDatumShift = 11;
        public static final short ConstantProjParameterValue_1 = 12;
        public static final short CoordinateOperationNotFound_2 = 13;
        public static final short DatumChangesDirectory_1 = 92;
        public static final short DatumOriginShallBeDate = 14;
        public static final short DeprecatedCode_3 = 15;
        public static final short DuplicatedParameterName_4 = 16;
        public static final short DuplicatedSpatialComponents_1 = 76;
        public static final short EllipsoidalHeightNotAllowed_1 = 77;
        public static final short FallbackDefaultFactoryVersion_2 = 17;
        public static final short FileNotFound_2 = 90;
        public static final short FileNotReadable_2 = 91;
        public static final short GeodeticDataBase_4 = 18;
        public static final short IgnoredServiceProvider_3 = 19;
        public static final short IllegalAxisDirection_2 = 20;
        public static final short IllegalOperationDimension_3 = 21;
        public static final short IllegalOperationForValueClass_1 = 22;
        public static final short IllegalParameterType_2 = 23;
        public static final short IllegalParameterValueClass_3 = 24;
        public static final short IllegalParameterValue_2 = 25;
        public static final short IllegalUnitFor_2 = 26;
        public static final short IncompatibleCoordinateSystemTypes = 27;
        public static final short IncompatibleDatum_2 = 28;
        public static final short InverseOperationUsesOppositeSign = 29;
        public static final short InverseOperationUsesSameSign = 30;
        public static final short LatitudesAreOpposite_2 = 31;
        public static final short LoadingDatumShiftFile_1 = 32;
        public static final short MisalignedDatumShiftGrid_1 = 94;
        public static final short MismatchedEllipsoidAxisLength_3 = 33;
        public static final short MismatchedOperationFactories_2 = 34;
        public static final short MismatchedParameterDescriptor_1 = 35;
        public static final short MismatchedPrimeMeridian_2 = 36;
        public static final short MisnamedParameter_1 = 38;
        public static final short MissingAuthorityCode_1 = 37;
        public static final short MissingAuthority_1 = 39;
        public static final short MissingHorizontalDimension_1 = 40;
        public static final short MissingInterpolationOrdinates = 41;
        public static final short MissingParameterValues_1 = 74;
        public static final short MissingSpatioTemporalDimension_1 = 42;
        public static final short MissingTemporalDimension_1 = 43;
        public static final short MissingValueForParameter_1 = 44;
        public static final short MissingValuesInLocalizationGrid = 81;
        public static final short MissingVerticalDimension_1 = 45;
        public static final short NoConvergence = 46;
        public static final short NoConvergenceForPoints_2 = 47;
        public static final short NoSuchAuthorityCodeInSubset_4 = 48;
        public static final short NoSuchAuthorityCode_3 = 49;
        public static final short NoSuchOperationMethod_1 = 50;
        public static final short NonConformAxes_2 = 72;
        public static final short NonConformCRS_3 = 73;
        public static final short NonHorizontalCRS_1 = 71;
        public static final short NonInvertibleMatrix_2 = 51;
        public static final short NonInvertibleOperation_1 = 52;
        public static final short NonInvertibleTransform = 53;
        public static final short NonLinearUnitConversion_2 = 54;
        public static final short NonMonotonicSequence_1 = 55;
        public static final short NonPerpendicularDirections_2 = 56;
        public static final short NonUniformScale = 57;
        public static final short NotASkewSymmetricMatrix = 58;
        public static final short NotAnAffineTransform = 59;
        public static final short NotFormalProjectionParameter_1 = 60;
        public static final short ParameterNotFound_2 = 61;
        public static final short PointsAreNotOnRegularGrid = 99;
        public static final short RecursiveCreateCallForCode_2 = 62;
        public static final short SingularMatrix = 63;
        public static final short StartOrEndPointNotSet_1 = 88;
        public static final short SyntaxErrorForAlias_1 = 97;
        public static final short UnexpectedComponentInURI = 80;
        public static final short UnexpectedDimensionForCS_1 = 64;
        public static final short UnexpectedTextAtLine_2 = 98;
        public static final short UnitlessParameter_1 = 65;
        public static final short UnknownAuthority_1 = 66;
        public static final short UnknownAxisDirection_1 = 67;
        public static final short UnmodifiableAffineTransform = 68;
        public static final short UnspecifiedDimensions = 69;
        public static final short UnspecifiedParameterValues = 70;
        public static final short UsingDatumShiftGrid_4 = 93;

        private Keys() {
        }
    }

    private static final class International
    extends ResourceInternationalString {
        private static final long serialVersionUID = 4553487496835099424L;

        International(short s) {
            super(s);
        }

        International(short s, Object object) {
            super(s, object);
        }

        @Override
        protected KeyConstants getKeyConstants() {
            return Keys.INSTANCE;
        }

        @Override
        protected IndexedResourceBundle getBundle(Locale locale) {
            return Resources.forLocale(locale);
        }
    }
}

