/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.shortcircuit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.shortcircuit.ClientMmap;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class ShortCircuitReplica {
    public static final Log LOG = LogFactory.getLog(ShortCircuitCache.class);
    final ExtendedBlockId key;
    private final FileInputStream dataStream;
    private final FileInputStream metaStream;
    private final BlockMetadataHeader metaHeader;
    private final ShortCircuitCache cache;
    private final long creationTimeMs;
    private final ShortCircuitShm.Slot slot;
    Object mmapData;
    boolean purged = false;
    int refCount = 2;
    private Long evictableTimeNs = null;

    public ShortCircuitReplica(ExtendedBlockId key, FileInputStream dataStream, FileInputStream metaStream, ShortCircuitCache cache, long creationTimeMs, ShortCircuitShm.Slot slot) throws IOException {
        this.key = key;
        this.dataStream = dataStream;
        this.metaStream = metaStream;
        this.metaHeader = BlockMetadataHeader.preadHeader(metaStream.getChannel());
        if (this.metaHeader.getVersion() != 1) {
            throw new IOException("invalid metadata header version " + this.metaHeader.getVersion() + ".  Can only handle version 1.");
        }
        this.cache = cache;
        this.creationTimeMs = creationTimeMs;
        this.slot = slot;
    }

    public void unref() {
        this.cache.unref(this);
    }

    boolean isStale() {
        long staleThresholdMs;
        if (this.slot != null) {
            boolean stale;
            boolean bl = stale = !this.slot.isValid();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this + ": checked shared memory segment.  isStale=" + stale));
            }
            return stale;
        }
        long deltaMs = Time.monotonicNow() - this.creationTimeMs;
        if (deltaMs > (staleThresholdMs = this.cache.getStaleThresholdMs())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this + " is stale because it's " + deltaMs + " ms old, and staleThresholdMs = " + staleThresholdMs));
            }
            return true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + " is not stale because it's only " + deltaMs + " ms old, and staleThresholdMs = " + staleThresholdMs));
        }
        return false;
    }

    public boolean addNoChecksumAnchor() {
        if (this.slot == null) {
            return false;
        }
        boolean result = this.slot.addAnchor();
        if (LOG.isTraceEnabled()) {
            if (result) {
                LOG.trace((Object)(this + ": added no-checksum anchor to slot " + this.slot));
            } else {
                LOG.trace((Object)(this + ": could not add no-checksum anchor to slot " + this.slot));
            }
        }
        return result;
    }

    public void removeNoChecksumAnchor() {
        if (this.slot != null) {
            this.slot.removeAnchor();
        }
    }

    @VisibleForTesting
    public boolean hasMmap() {
        return this.mmapData != null && this.mmapData instanceof MappedByteBuffer;
    }

    void munmap() {
        MappedByteBuffer mmap = (MappedByteBuffer)this.mmapData;
        NativeIO.POSIX.munmap((MappedByteBuffer)mmap);
        this.mmapData = null;
    }

    void close() {
        String suffix = "";
        Preconditions.checkState((this.refCount == 0 ? 1 : 0) != 0, (Object)("tried to close replica with refCount " + this.refCount + ": " + this));
        this.refCount = -1;
        Preconditions.checkState((boolean)this.purged, (Object)("tried to close unpurged replica " + this));
        if (this.hasMmap()) {
            this.munmap();
            suffix = suffix + "  munmapped.";
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dataStream, this.metaStream});
        if (this.slot != null) {
            this.cache.scheduleSlotReleaser(this.slot);
            suffix = suffix + "  scheduling " + this.slot + " for later release.";
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("closed " + this + suffix));
        }
    }

    public FileInputStream getDataStream() {
        return this.dataStream;
    }

    public FileInputStream getMetaStream() {
        return this.metaStream;
    }

    public BlockMetadataHeader getMetaHeader() {
        return this.metaHeader;
    }

    public ExtendedBlockId getKey() {
        return this.key;
    }

    public ClientMmap getOrCreateClientMmap(boolean anchor) {
        return this.cache.getOrCreateClientMmap(this, anchor);
    }

    MappedByteBuffer loadMmapInternal() {
        try {
            FileChannel channel = this.dataStream.getChannel();
            MappedByteBuffer mmap = channel.map(FileChannel.MapMode.READ_ONLY, 0L, Math.min(Integer.MAX_VALUE, channel.size()));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this + ": created mmap of size " + channel.size()));
            }
            return mmap;
        }
        catch (IOException e) {
            LOG.warn((Object)(this + ": mmap error"), (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            LOG.warn((Object)(this + ": mmap error"), (Throwable)e);
            return null;
        }
    }

    public Long getEvictableTimeNs() {
        return this.evictableTimeNs;
    }

    void setEvictableTimeNs(Long evictableTimeNs) {
        this.evictableTimeNs = evictableTimeNs;
    }

    @VisibleForTesting
    public ShortCircuitShm.Slot getSlot() {
        return this.slot;
    }

    public String toString() {
        return "ShortCircuitReplica{" + "key=" + this.key + ", metaHeader.version=" + this.metaHeader.getVersion() + ", metaHeader.checksum=" + this.metaHeader.getChecksum() + ", ident=" + "0x" + Integer.toHexString(System.identityHashCode(this)) + ", creationTimeMs=" + this.creationTimeMs + "}";
    }
}

