/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.csws;

import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.interfaces.UTF8Stdout;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class GetConnectionInfo {
    public static final String _rcsid = "@(#)$Id: GetConnectionInfo.java 988245 2010-08-23 18:39:35Z kwright $";

    private GetConnectionInfo() {
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: GetConnectionInfo <connection_name>");
            System.err.println("");
            System.err.println("The result will be printed to standard out, in UTF-8 encoding, and will contain the following columns:");
            System.err.println("    csws_server");
            System.exit(1);
        }
        String connectionName = args[0];
        try {
            IThreadContext tc = ThreadContextFactory.make();
            ManifoldCF.initializeEnvironment((IThreadContext)tc);
            IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make((IThreadContext)tc);
            IRepositoryConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                throw new ManifoldCFException("Connection " + connectionName + " does not exist");
            }
            if (connection.getClassName() == null || !connection.getClassName().equals("org.apache.manifoldcf.crawler.connectors.csws.CswsConnector")) {
                throw new ManifoldCFException("Command can only be used on working Csws connections.");
            }
            ConfigParams cfg = connection.getConfigParams();
            UTF8Stdout.println((Object)GetConnectionInfo.commaEscape(cfg.getParameter("Server name")));
            System.err.println("Connection info done");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    protected static String commaEscape(String input) {
        StringBuilder output = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char x;
            if ((x = input.charAt(i++)) == '\\' || x == ',') {
                output.append("\\");
            }
            output.append(x);
        }
        return output.toString();
    }
}

