/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.jira;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.core.common.DateParser;
import org.apache.manifoldcf.crawler.connectors.jira.JiraJSONResponse;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JiraIssue
extends JiraJSONResponse {
    private static final String KEY_FIELDS = "fields";
    private static final String KEY_KEY = "key";
    private static final String KEY_SELF = "self";
    private static final String KEY_CREATED = "created";
    private static final String KEY_UPDATED = "updated";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_SUMMARY = "summary";

    public String getKey() {
        Object key = ((JSONObject)this.object).get((Object)KEY_KEY);
        if (key == null) {
            return null;
        }
        return key.toString();
    }

    public String getSelf() {
        Object key = ((JSONObject)this.object).get((Object)KEY_SELF);
        if (key == null) {
            return null;
        }
        return key.toString();
    }

    public Date getCreatedDate() {
        JSONObject fields = (JSONObject)((JSONObject)this.object).get((Object)KEY_FIELDS);
        if (fields == null) {
            return null;
        }
        Object createdDate = fields.get((Object)KEY_CREATED);
        if (createdDate == null) {
            return null;
        }
        return DateParser.parseISO8601Date((String)createdDate.toString());
    }

    public Date getUpdatedDate() {
        JSONObject fields = (JSONObject)((JSONObject)this.object).get((Object)KEY_FIELDS);
        if (fields == null) {
            return null;
        }
        Object updatedDate = fields.get((Object)KEY_UPDATED);
        if (updatedDate == null) {
            return null;
        }
        return DateParser.parseISO8601Date((String)updatedDate.toString());
    }

    public String getDescription() {
        JSONObject fields = (JSONObject)((JSONObject)this.object).get((Object)KEY_FIELDS);
        if (fields == null) {
            return null;
        }
        Object description = fields.get((Object)KEY_DESCRIPTION);
        if (description == null) {
            return null;
        }
        return description.toString();
    }

    public String getSummary() {
        JSONObject fields = (JSONObject)((JSONObject)this.object).get((Object)KEY_FIELDS);
        if (fields == null) {
            return null;
        }
        Object summary = fields.get((Object)KEY_SUMMARY);
        if (summary == null) {
            return null;
        }
        return summary.toString();
    }

    public Map<String, String[]> getMetadata() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        JSONObject fields = (JSONObject)((JSONObject)this.object).get((Object)KEY_FIELDS);
        if (fields != null) {
            JiraIssue.addMetadataToMap("", fields, map);
        }
        HashMap<String, String[]> rmap = new HashMap<String, String[]>();
        for (String key : map.keySet()) {
            List values = (List)map.get(key);
            String[] valueArray = values.toArray(new String[0]);
            rmap.put(key, valueArray);
        }
        return rmap;
    }

    protected static void addMetadataToMap(String parent, Object cval, Map<String, List<String>> currentMap) {
        if (cval == null) {
            return;
        }
        if (cval instanceof String || cval instanceof Number || cval instanceof Boolean) {
            List<String> current = currentMap.get(parent);
            if (current == null) {
                current = new ArrayList<String>();
                currentMap.put(parent, current);
            }
            current.add(cval.toString());
            return;
        }
        if (cval instanceof JSONArray) {
            JSONArray ja = (JSONArray)cval;
            for (Object subpiece : ja) {
                JiraIssue.addMetadataToMap(parent, subpiece, currentMap);
            }
            return;
        }
        if (cval instanceof JSONObject) {
            JSONObject jo = (JSONObject)cval;
            Object append = "";
            if (parent.length() > 0) {
                append = parent + "_";
            }
            for (Object key : jo.keySet()) {
                Object value = jo.get(key);
                if (value == null) continue;
                String newKey = (String)append + key;
                JiraIssue.addMetadataToMap(newKey, value, currentMap);
            }
            return;
        }
        throw new IllegalArgumentException("Unknown object to addMetadataToMap: " + cval.getClass().getName());
    }
}

