/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities;

import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnector;
import org.apache.manifoldcf.core.connector.BaseConnector;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public abstract class BaseAuthorityConnector
extends BaseConnector
implements IAuthorityConnector {
    public static final String _rcsid = "@(#)$Id: BaseAuthorityConnector.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final AuthorizationResponse RESPONSE_UNREACHABLE = new AuthorizationResponse(new String[]{"DEAD_AUTHORITY"}, 1);
    protected static final AuthorizationResponse RESPONSE_USERNOTFOUND = new AuthorizationResponse(new String[]{"DEAD_AUTHORITY"}, 2);
    protected static final AuthorizationResponse RESPONSE_USERUNAUTHORIZED = new AuthorizationResponse(new String[]{"DEAD_AUTHORITY"}, 3);
    protected static final AuthorizationResponse RESPONSE_UNREACHABLE_ADDITIVE = new AuthorizationResponse(new String[0], 1);
    protected static final AuthorizationResponse RESPONSE_USERNOTFOUND_ADDITIVE = new AuthorizationResponse(new String[0], 2);
    protected static final AuthorizationResponse RESPONSE_USERUNAUTHORIZED_ADDITIVE = new AuthorizationResponse(new String[0], 3);

    @Override
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        try {
            String[] accessTokens = this.getAccessTokens(userName);
            if (accessTokens == null) {
                return new AuthorizationResponse(new String[0], 2);
            }
            return new AuthorizationResponse(accessTokens, 0);
        }
        catch (ManifoldCFException e) {
            String[] defaultAccessTokens = this.getDefaultAccessTokens(userName);
            if (defaultAccessTokens == null) {
                return new AuthorizationResponse(new String[0], 3);
            }
            return new AuthorizationResponse(defaultAccessTokens, 1);
        }
    }

    @Override
    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        String[] acls = this.getDefaultAccessTokens(userName);
        if (acls == null) {
            return new AuthorizationResponse(new String[0], 3);
        }
        return new AuthorizationResponse(acls, 1);
    }

    public String[] getAccessTokens(String userName) throws ManifoldCFException {
        return null;
    }

    public String[] getDefaultAccessTokens(String userName) {
        return null;
    }
}

