"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const mocha_1 = require("mocha");
const sinon = __importStar(require("sinon"));
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const AjaxImpl_1 = require("../../impl/AjaxImpl");
const chai_1 = require("chai");
var defaultMyFaces = StandardInits_1.StandardInits.defaultMyFaces;
const mona_dish_1 = require("mona-dish");
const FakeWebsocket_1 = require("./FakeWebsocket");
var assertType = mona_dish_1.Lang.assertType;
(0, mocha_1.describe)('Tests the jsf websocket client side api on high level (generic test without any myfaces dependencies', function () {
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = defaultMyFaces();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.jsfAjaxResponse = sinon.stub(global.faces.ajax, "response");
                this.fakeWebsocket = new FakeWebsocket_1.FakeWebsocket();
                this.socket = sinon.stub(window, 'WebSocket').returns(this.fakeWebsocket);
                global.WebSocket = this.socket;
                this.pushImpl = global.PushImpl;
                this.initSpy = sinon.spy(this.pushImpl, "init");
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    this.jsfAjaxResponse.restore();
                    this.socket.restore();
                    this.initSpy.restore();
                    delete global.WebSocket;
                    AjaxImpl_1.Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    it("must register a channel", function (done) {
        /**
         *   export function init(socketClientId: string,
         uri: string,
         channel: string,
         onopen: Function,
         onmessage: Function,
         onclose: Function,
         behaviorScripts: any,
         autoconnect: boolean) {
            PushImpl.init(socketClientId, uri, channel, onopen, onmessage, onclose, behaviorScripts, autoconnect);
        }
         */
        var _a, _b;
        try {
            faces.push.init("clientId1", "booga.ws", "mychannel", () => {
                done();
            }, () => {
            }, () => {
            }, "", true);
            (0, chai_1.expect)(this.initSpy.called).to.be.true;
            let calledArgs = (_b = (_a = this.initSpy) === null || _a === void 0 ? void 0 : _a.getCall(0)) === null || _b === void 0 ? void 0 : _b.args;
            (0, chai_1.expect)(calledArgs[0] == "clientId1").to.be.true;
            (0, chai_1.expect)(calledArgs[1] == "booga.ws").to.be.true;
            (0, chai_1.expect)(calledArgs[2] == "mychannel").to.be.true;
            (0, chai_1.expect)(assertType(calledArgs[3], "function")).to.be.true;
            (0, chai_1.expect)(assertType(calledArgs[4], "function")).to.be.true;
            (0, chai_1.expect)(assertType(calledArgs[5], "function")).to.be.true;
            //implementation specific
            (0, chai_1.expect)("clientId1" in this.pushImpl.components, "a component must be registered").to.be.true;
            (0, chai_1.expect)("booga.ws" in this.pushImpl.sockets, "a socket must be registered").to.be.true;
        }
        finally {
        }
    });
    it("callbacks must be called", function (done) {
        let openCalled = false;
        let closeCalled = false;
        let messageCalled = false;
        let msg = null;
        let cnl = null;
        new Promise((resolve) => {
            faces.push.init("blarg", "booga.ws", "mychannel", () => {
                openCalled = true;
                this.fakeWebsocket._respond({ data: '"booga"' });
            }, (message, channel) => {
                messageCalled = true;
                msg = message;
                cnl = channel;
                resolve(() => true);
            }, () => {
                closeCalled = true;
            }, "", true);
        }).then(() => {
            (0, chai_1.expect)(openCalled, "Open must have been called due to autoConnect").to.be.true;
            (0, chai_1.expect)(messageCalled, "on a server response the message must have been called").to.be.true;
            (0, chai_1.expect)(msg, "proper message must be passed").to.eq("booga");
            (0, chai_1.expect)(cnl, "proper message must be passed").to.eq("mychannel");
            (0, chai_1.expect)(closeCalled, "websocket still open").to.be.false;
            faces.push.close("blarg");
            (0, chai_1.expect)(closeCalled, "websocket now closed").to.be.true;
            done();
        });
    });
    it("manual open must work", function (done) {
        let openCalled = false;
        let closeCalled = false;
        let messageCalled = false;
        let msg = null;
        let cnl = null;
        new Promise((resolve) => {
            faces.push.init("blarg", "booga.ws", "mychannel", () => {
                openCalled = true;
                this.fakeWebsocket._respond({ data: '"booga"' });
            }, (message, channel) => {
                messageCalled = true;
                msg = message;
                cnl = channel;
                resolve(() => true);
            }, () => {
                closeCalled = true;
            }, "", false);
            faces.push.open("blarg");
        }).then(() => {
            (0, chai_1.expect)(openCalled, "Open must have been called due to open").to.be.true;
            (0, chai_1.expect)(messageCalled, "on a server response the message must have been called").to.be.true;
            (0, chai_1.expect)(msg, "proper message must be passed").to.eq("booga");
            (0, chai_1.expect)(cnl, "proper message must be passed").to.eq("mychannel");
            (0, chai_1.expect)(closeCalled, "websocket still open").to.be.false;
            faces.push.close("blarg");
            (0, chai_1.expect)(closeCalled, "websocket now closed").to.be.true;
            done();
        });
    });
});
//# sourceMappingURL=WebsocketTest.js.map