/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { Config, XMLQuery } from "mona-dish";
import { DQ } from "mona-dish";
/**
 * a set of internal code assertions
 * which raise an error
 *
 */
export declare module Assertions {
    function assertRequestIntegrity(options: Config, elem: DQ): void | never;
    function assertUrlExists(node: XMLQuery): void | never;
    /**
     * checks the xml for various issues which can occur
     * and prevent a proper processing
     */
    function assertValidXMLResponse(responseXML: XMLQuery): void | never;
    /**
     * internal helper which raises an error in the
     * format we need for further processing
     *
     * @param error
     * @param message the message
     * @param caller
     * @param title the title of the error (optional)
     * @param name the name of the error (optional)
     */
    function raiseError(error: any, message: string, caller?: string, title?: string, name?: string): Error;
    function assert(value: any, msg?: string, caller?: string, title?: string): asserts value;
    function assertType(value: any, theType: any, msg?: string, caller?: string, title?: string): asserts value;
    function assertFunction(value: any, msg?: string, caller?: string, title?: string): asserts value is Function;
    function assertDelay(value: any): void;
}
