/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.util.map;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletAbstractMap<V>
extends AbstractMap<String, V> {
    static final String ILLEGAL_ARGUMENT = "Only supported in a portlet environment";
    private Set<String> mKeySet;
    private Collection<V> mValues;
    private Set<Map.Entry<String, V>> mEntrySet;

    @Override
    public void clear() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<String> e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            names.add(e.nextElement());
        }
        for (String name : names) {
            this.removeAttribute(name);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getAttribute(key.toString()) != null;
    }

    @Override
    public boolean containsValue(Object findValue) {
        if (findValue == null) {
            return false;
        }
        Enumeration<String> e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            V value = this.getAttribute(e.nextElement());
            if (!findValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.mEntrySet != null ? this.mEntrySet : (this.mEntrySet = new EntrySet());
    }

    @Override
    public V get(Object key) {
        return this.getAttribute(key.toString());
    }

    @Override
    public boolean isEmpty() {
        return !this.getAttributeNames().hasMoreElements();
    }

    @Override
    public Set<String> keySet() {
        return this.mKeySet != null ? this.mKeySet : (this.mKeySet = new KeySet());
    }

    @Override
    public V put(String key, V value) {
        String localKey = key.toString();
        V retval = this.getAttribute(localKey);
        this.setAttribute(localKey, value);
        return retval;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> t) {
        for (Map.Entry<String, V> entry : t.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        String localKey = key.toString();
        V retval = this.getAttribute(localKey);
        this.removeAttribute(localKey);
        return retval;
    }

    @Override
    public int size() {
        int size = 0;
        Enumeration<String> e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            ++size;
            e.nextElement();
        }
        return size;
    }

    @Override
    public Collection<V> values() {
        return this.mValues != null ? this.mValues : (this.mValues = new Values());
    }

    protected abstract V getAttribute(String var1);

    protected abstract void setAttribute(String var1, V var2);

    protected abstract void removeAttribute(String var1);

    protected abstract Enumeration<String> getAttributeNames();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySetEntry
    implements Map.Entry<String, V> {
        private final String mKey;

        public EntrySetEntry(String currentKey) {
            this.mKey = currentKey;
        }

        @Override
        public String getKey() {
            return this.mKey;
        }

        @Override
        public V getValue() {
            return PortletAbstractMap.this.get(this.mKey);
        }

        @Override
        public V setValue(V value) {
            return PortletAbstractMap.this.put(this.mKey, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends KeyIteratorWrapper<Map.Entry<String, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<String, V> next() {
            return new EntrySetEntry(this.nextKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends BaseMapContentSet<Map.Entry<String, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) {
                return false;
            }
            return value.equals(PortletAbstractMap.this.get(key));
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null || !value.equals(PortletAbstractMap.this.get(key))) {
                return false;
            }
            return PortletAbstractMap.this.remove(key) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesIterator
    extends KeyIteratorWrapper<V> {
        private ValuesIterator() {
        }

        @Override
        public V next() {
            return PortletAbstractMap.this.get(this.nextKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends BaseMapContentSet<V> {
        private Values() {
        }

        @Override
        public boolean contains(Object o) {
            return PortletAbstractMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                return false;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                it.remove();
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class KeyIteratorWrapper<T>
    implements Iterator<T> {
        private KeyIterator wrapped;

        protected KeyIteratorWrapper() {
            this.wrapped = new KeyIterator();
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        protected String nextKey() {
            return this.wrapped.next();
        }

        @Override
        public void remove() {
            this.wrapped.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    implements Iterator<String> {
        protected final Enumeration<String> mEnum;
        protected String mKey;

        private KeyIterator() {
            this.mEnum = PortletAbstractMap.this.getAttributeNames();
        }

        @Override
        public void remove() {
            if (this.mKey == null) {
                throw new NoSuchElementException();
            }
            PortletAbstractMap.this.remove(this.mKey);
        }

        @Override
        public boolean hasNext() {
            return this.mEnum.hasMoreElements();
        }

        @Override
        public String next() {
            this.mKey = this.mEnum.nextElement();
            return this.mKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends BaseMapContentSet<String> {
        private KeySet() {
        }

        @Override
        public boolean contains(Object o) {
            return PortletAbstractMap.this.containsKey(o);
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object o) {
            return PortletAbstractMap.this.remove(o) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseMapContentSet<T>
    extends AbstractSet<T> {
        private BaseMapContentSet() {
        }

        @Override
        public void clear() {
            PortletAbstractMap.this.clear();
        }

        @Override
        public int size() {
            return PortletAbstractMap.this.size();
        }
    }
}

