/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetDeviceStatusTagged is the corresponding interface of BACnetDeviceStatusTagged
type BACnetDeviceStatusTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetDeviceStatus
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetDeviceStatusTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetDeviceStatusTagged()
	// CreateBuilder creates a BACnetDeviceStatusTaggedBuilder
	CreateBACnetDeviceStatusTaggedBuilder() BACnetDeviceStatusTaggedBuilder
}

// _BACnetDeviceStatusTagged is the data-structure of this message
type _BACnetDeviceStatusTagged struct {
	Header           BACnetTagHeader
	Value            BACnetDeviceStatus
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetDeviceStatusTagged = (*_BACnetDeviceStatusTagged)(nil)

// NewBACnetDeviceStatusTagged factory function for _BACnetDeviceStatusTagged
func NewBACnetDeviceStatusTagged(header BACnetTagHeader, value BACnetDeviceStatus, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetDeviceStatusTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetDeviceStatusTagged must not be nil")
	}
	return &_BACnetDeviceStatusTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetDeviceStatusTaggedBuilder is a builder for BACnetDeviceStatusTagged
type BACnetDeviceStatusTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetDeviceStatus, proprietaryValue uint32) BACnetDeviceStatusTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetDeviceStatusTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetDeviceStatusTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetDeviceStatus) BACnetDeviceStatusTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetDeviceStatusTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetDeviceStatusTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetDeviceStatusTaggedBuilder
	// Build builds the BACnetDeviceStatusTagged or returns an error if something is wrong
	Build() (BACnetDeviceStatusTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetDeviceStatusTagged
}

// NewBACnetDeviceStatusTaggedBuilder() creates a BACnetDeviceStatusTaggedBuilder
func NewBACnetDeviceStatusTaggedBuilder() BACnetDeviceStatusTaggedBuilder {
	return &_BACnetDeviceStatusTaggedBuilder{_BACnetDeviceStatusTagged: new(_BACnetDeviceStatusTagged)}
}

type _BACnetDeviceStatusTaggedBuilder struct {
	*_BACnetDeviceStatusTagged

	collectedErr []error
}

var _ (BACnetDeviceStatusTaggedBuilder) = (*_BACnetDeviceStatusTaggedBuilder)(nil)

func (b *_BACnetDeviceStatusTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetDeviceStatus, proprietaryValue uint32) BACnetDeviceStatusTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetDeviceStatusTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetDeviceStatusTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetDeviceStatusTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetDeviceStatusTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetDeviceStatusTaggedBuilder) WithValue(value BACnetDeviceStatus) BACnetDeviceStatusTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetDeviceStatusTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetDeviceStatusTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetDeviceStatusTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetDeviceStatusTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetDeviceStatusTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetDeviceStatusTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetDeviceStatusTaggedBuilder) Build() (BACnetDeviceStatusTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetDeviceStatusTagged.deepCopy(), nil
}

func (b *_BACnetDeviceStatusTaggedBuilder) MustBuild() BACnetDeviceStatusTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetDeviceStatusTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetDeviceStatusTaggedBuilder().(*_BACnetDeviceStatusTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetDeviceStatusTaggedBuilder creates a BACnetDeviceStatusTaggedBuilder
func (b *_BACnetDeviceStatusTagged) CreateBACnetDeviceStatusTaggedBuilder() BACnetDeviceStatusTaggedBuilder {
	if b == nil {
		return NewBACnetDeviceStatusTaggedBuilder()
	}
	return &_BACnetDeviceStatusTaggedBuilder{_BACnetDeviceStatusTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetDeviceStatusTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetDeviceStatusTagged) GetValue() BACnetDeviceStatus {
	return m.Value
}

func (m *_BACnetDeviceStatusTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetDeviceStatusTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetDeviceStatus_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetDeviceStatusTagged(structType any) BACnetDeviceStatusTagged {
	if casted, ok := structType.(BACnetDeviceStatusTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetDeviceStatusTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetDeviceStatusTagged) GetTypeName() string {
	return "BACnetDeviceStatusTagged"
}

func (m *_BACnetDeviceStatusTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetDeviceStatusTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetDeviceStatusTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetDeviceStatusTagged, error) {
	return BACnetDeviceStatusTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetDeviceStatusTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDeviceStatusTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDeviceStatusTagged, error) {
		return BACnetDeviceStatusTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetDeviceStatusTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetDeviceStatusTagged, error) {
	v, err := (&_BACnetDeviceStatusTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetDeviceStatusTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetDeviceStatusTagged BACnetDeviceStatusTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetDeviceStatusTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetDeviceStatusTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetDeviceStatus](ctx, "value", readBuffer, EnsureType[BACnetDeviceStatus](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetDeviceStatus_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetDeviceStatus_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetDeviceStatusTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetDeviceStatusTagged")
	}

	return m, nil
}

func (m *_BACnetDeviceStatusTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetDeviceStatusTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetDeviceStatusTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetDeviceStatusTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetDeviceStatus](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetDeviceStatusTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetDeviceStatusTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetDeviceStatusTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetDeviceStatusTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetDeviceStatusTagged) IsBACnetDeviceStatusTagged() {}

func (m *_BACnetDeviceStatusTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetDeviceStatusTagged) deepCopy() *_BACnetDeviceStatusTagged {
	if m == nil {
		return nil
	}
	_BACnetDeviceStatusTaggedCopy := &_BACnetDeviceStatusTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetDeviceStatusTaggedCopy
}

func (m *_BACnetDeviceStatusTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
