/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ExtensionObjectEncodingMask is the corresponding interface of ExtensionObjectEncodingMask
type ExtensionObjectEncodingMask interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetTypeIdSpecified returns TypeIdSpecified (property field)
	GetTypeIdSpecified() bool
	// GetXmlBody returns XmlBody (property field)
	GetXmlBody() bool
	// GetBinaryBody returns BinaryBody (property field)
	GetBinaryBody() bool
	// IsExtensionObjectEncodingMask is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsExtensionObjectEncodingMask()
	// CreateBuilder creates a ExtensionObjectEncodingMaskBuilder
	CreateExtensionObjectEncodingMaskBuilder() ExtensionObjectEncodingMaskBuilder
}

// _ExtensionObjectEncodingMask is the data-structure of this message
type _ExtensionObjectEncodingMask struct {
	TypeIdSpecified bool
	XmlBody         bool
	BinaryBody      bool
	// Reserved Fields
	reservedField0 *int8
}

var _ ExtensionObjectEncodingMask = (*_ExtensionObjectEncodingMask)(nil)

// NewExtensionObjectEncodingMask factory function for _ExtensionObjectEncodingMask
func NewExtensionObjectEncodingMask(typeIdSpecified bool, xmlBody bool, binaryBody bool) *_ExtensionObjectEncodingMask {
	return &_ExtensionObjectEncodingMask{TypeIdSpecified: typeIdSpecified, XmlBody: xmlBody, BinaryBody: binaryBody}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ExtensionObjectEncodingMaskBuilder is a builder for ExtensionObjectEncodingMask
type ExtensionObjectEncodingMaskBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(typeIdSpecified bool, xmlBody bool, binaryBody bool) ExtensionObjectEncodingMaskBuilder
	// WithTypeIdSpecified adds TypeIdSpecified (property field)
	WithTypeIdSpecified(bool) ExtensionObjectEncodingMaskBuilder
	// WithXmlBody adds XmlBody (property field)
	WithXmlBody(bool) ExtensionObjectEncodingMaskBuilder
	// WithBinaryBody adds BinaryBody (property field)
	WithBinaryBody(bool) ExtensionObjectEncodingMaskBuilder
	// Build builds the ExtensionObjectEncodingMask or returns an error if something is wrong
	Build() (ExtensionObjectEncodingMask, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ExtensionObjectEncodingMask
}

// NewExtensionObjectEncodingMaskBuilder() creates a ExtensionObjectEncodingMaskBuilder
func NewExtensionObjectEncodingMaskBuilder() ExtensionObjectEncodingMaskBuilder {
	return &_ExtensionObjectEncodingMaskBuilder{_ExtensionObjectEncodingMask: new(_ExtensionObjectEncodingMask)}
}

type _ExtensionObjectEncodingMaskBuilder struct {
	*_ExtensionObjectEncodingMask

	collectedErr []error
}

var _ (ExtensionObjectEncodingMaskBuilder) = (*_ExtensionObjectEncodingMaskBuilder)(nil)

func (b *_ExtensionObjectEncodingMaskBuilder) WithMandatoryFields(typeIdSpecified bool, xmlBody bool, binaryBody bool) ExtensionObjectEncodingMaskBuilder {
	return b.WithTypeIdSpecified(typeIdSpecified).WithXmlBody(xmlBody).WithBinaryBody(binaryBody)
}

func (b *_ExtensionObjectEncodingMaskBuilder) WithTypeIdSpecified(typeIdSpecified bool) ExtensionObjectEncodingMaskBuilder {
	b.TypeIdSpecified = typeIdSpecified
	return b
}

func (b *_ExtensionObjectEncodingMaskBuilder) WithXmlBody(xmlBody bool) ExtensionObjectEncodingMaskBuilder {
	b.XmlBody = xmlBody
	return b
}

func (b *_ExtensionObjectEncodingMaskBuilder) WithBinaryBody(binaryBody bool) ExtensionObjectEncodingMaskBuilder {
	b.BinaryBody = binaryBody
	return b
}

func (b *_ExtensionObjectEncodingMaskBuilder) Build() (ExtensionObjectEncodingMask, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ExtensionObjectEncodingMask.deepCopy(), nil
}

func (b *_ExtensionObjectEncodingMaskBuilder) MustBuild() ExtensionObjectEncodingMask {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ExtensionObjectEncodingMaskBuilder) DeepCopy() any {
	_copy := b.CreateExtensionObjectEncodingMaskBuilder().(*_ExtensionObjectEncodingMaskBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateExtensionObjectEncodingMaskBuilder creates a ExtensionObjectEncodingMaskBuilder
func (b *_ExtensionObjectEncodingMask) CreateExtensionObjectEncodingMaskBuilder() ExtensionObjectEncodingMaskBuilder {
	if b == nil {
		return NewExtensionObjectEncodingMaskBuilder()
	}
	return &_ExtensionObjectEncodingMaskBuilder{_ExtensionObjectEncodingMask: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ExtensionObjectEncodingMask) GetTypeIdSpecified() bool {
	return m.TypeIdSpecified
}

func (m *_ExtensionObjectEncodingMask) GetXmlBody() bool {
	return m.XmlBody
}

func (m *_ExtensionObjectEncodingMask) GetBinaryBody() bool {
	return m.BinaryBody
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastExtensionObjectEncodingMask(structType any) ExtensionObjectEncodingMask {
	if casted, ok := structType.(ExtensionObjectEncodingMask); ok {
		return casted
	}
	if casted, ok := structType.(*ExtensionObjectEncodingMask); ok {
		return *casted
	}
	return nil
}

func (m *_ExtensionObjectEncodingMask) GetTypeName() string {
	return "ExtensionObjectEncodingMask"
}

func (m *_ExtensionObjectEncodingMask) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Reserved Field (reserved)
	lengthInBits += 5

	// Simple field (typeIdSpecified)
	lengthInBits += 1

	// Simple field (xmlBody)
	lengthInBits += 1

	// Simple field (binaryBody)
	lengthInBits += 1

	return lengthInBits
}

func (m *_ExtensionObjectEncodingMask) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ExtensionObjectEncodingMaskParse(ctx context.Context, theBytes []byte) (ExtensionObjectEncodingMask, error) {
	return ExtensionObjectEncodingMaskParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ExtensionObjectEncodingMaskParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (ExtensionObjectEncodingMask, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (ExtensionObjectEncodingMask, error) {
		return ExtensionObjectEncodingMaskParseWithBuffer(ctx, readBuffer)
	}
}

func ExtensionObjectEncodingMaskParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ExtensionObjectEncodingMask, error) {
	v, err := (&_ExtensionObjectEncodingMask{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_ExtensionObjectEncodingMask) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__extensionObjectEncodingMask ExtensionObjectEncodingMask, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ExtensionObjectEncodingMask"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ExtensionObjectEncodingMask")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadSignedByte(readBuffer, uint8(5)), int8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	typeIdSpecified, err := ReadSimpleField(ctx, "typeIdSpecified", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'typeIdSpecified' field"))
	}
	m.TypeIdSpecified = typeIdSpecified

	xmlBody, err := ReadSimpleField(ctx, "xmlBody", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'xmlBody' field"))
	}
	m.XmlBody = xmlBody

	binaryBody, err := ReadSimpleField(ctx, "binaryBody", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'binaryBody' field"))
	}
	m.BinaryBody = binaryBody

	if closeErr := readBuffer.CloseContext("ExtensionObjectEncodingMask"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ExtensionObjectEncodingMask")
	}

	return m, nil
}

func (m *_ExtensionObjectEncodingMask) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ExtensionObjectEncodingMask) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ExtensionObjectEncodingMask"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ExtensionObjectEncodingMask")
	}

	if err := WriteReservedField[int8](ctx, "reserved", int8(0x00), WriteSignedByte(writeBuffer, 5)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 1")
	}

	if err := WriteSimpleField[bool](ctx, "typeIdSpecified", m.GetTypeIdSpecified(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'typeIdSpecified' field")
	}

	if err := WriteSimpleField[bool](ctx, "xmlBody", m.GetXmlBody(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'xmlBody' field")
	}

	if err := WriteSimpleField[bool](ctx, "binaryBody", m.GetBinaryBody(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'binaryBody' field")
	}

	if popErr := writeBuffer.PopContext("ExtensionObjectEncodingMask"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ExtensionObjectEncodingMask")
	}
	return nil
}

func (m *_ExtensionObjectEncodingMask) IsExtensionObjectEncodingMask() {}

func (m *_ExtensionObjectEncodingMask) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ExtensionObjectEncodingMask) deepCopy() *_ExtensionObjectEncodingMask {
	if m == nil {
		return nil
	}
	_ExtensionObjectEncodingMaskCopy := &_ExtensionObjectEncodingMask{
		m.TypeIdSpecified,
		m.XmlBody,
		m.BinaryBody,
		m.reservedField0,
	}
	return _ExtensionObjectEncodingMaskCopy
}

func (m *_ExtensionObjectEncodingMask) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
