/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NetworkRoute implements Message {

  // Properties.
  protected final NetworkProtocolControlInformation networkPCI;
  protected final List<BridgeAddress> additionalBridgeAddresses;

  public NetworkRoute(
      NetworkProtocolControlInformation networkPCI, List<BridgeAddress> additionalBridgeAddresses) {
    super();
    this.networkPCI = networkPCI;
    this.additionalBridgeAddresses = additionalBridgeAddresses;
  }

  public NetworkProtocolControlInformation getNetworkPCI() {
    return networkPCI;
  }

  public List<BridgeAddress> getAdditionalBridgeAddresses() {
    return additionalBridgeAddresses;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NetworkRoute");

    // Simple Field (networkPCI)
    writeSimpleField("networkPCI", networkPCI, writeComplex(writeBuffer));

    // Array Field (additionalBridgeAddresses)
    writeComplexTypeArrayField("additionalBridgeAddresses", additionalBridgeAddresses, writeBuffer);

    writeBuffer.popContext("NetworkRoute");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    NetworkRoute _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (networkPCI)
    lengthInBits += networkPCI.getLengthInBits();

    // Array field
    if (additionalBridgeAddresses != null) {
      int i = 0;
      for (BridgeAddress element : additionalBridgeAddresses) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= additionalBridgeAddresses.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static NetworkRoute staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("NetworkRoute");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NetworkProtocolControlInformation networkPCI =
        readSimpleField(
            "networkPCI",
            readComplex(
                () -> NetworkProtocolControlInformation.staticParse(readBuffer), readBuffer));

    List<BridgeAddress> additionalBridgeAddresses =
        readCountArrayField(
            "additionalBridgeAddresses",
            readComplex(() -> BridgeAddress.staticParse(readBuffer), readBuffer),
            (networkPCI.getStackDepth()) - (1));

    readBuffer.closeContext("NetworkRoute");
    // Create the instance
    NetworkRoute _networkRoute;
    _networkRoute = new NetworkRoute(networkPCI, additionalBridgeAddresses);
    return _networkRoute;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NetworkRoute)) {
      return false;
    }
    NetworkRoute that = (NetworkRoute) o;
    return (getNetworkPCI() == that.getNetworkPCI())
        && (getAdditionalBridgeAddresses() == that.getAdditionalBridgeAddresses())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getNetworkPCI(), getAdditionalBridgeAddresses());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
