/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AuthorizationServiceConfigurationDataType extends ExtensionObjectDefinition
    implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 19447;
  }

  // Properties.
  protected final PascalString name;
  protected final List<KeyValuePair> recordProperties;
  protected final PascalString serviceUri;
  protected final List<PascalByteString> serviceCertificate;
  protected final PascalString issuerEndpointSettings;

  public AuthorizationServiceConfigurationDataType(
      PascalString name,
      List<KeyValuePair> recordProperties,
      PascalString serviceUri,
      List<PascalByteString> serviceCertificate,
      PascalString issuerEndpointSettings) {
    super();
    this.name = name;
    this.recordProperties = recordProperties;
    this.serviceUri = serviceUri;
    this.serviceCertificate = serviceCertificate;
    this.issuerEndpointSettings = issuerEndpointSettings;
  }

  public PascalString getName() {
    return name;
  }

  public List<KeyValuePair> getRecordProperties() {
    return recordProperties;
  }

  public PascalString getServiceUri() {
    return serviceUri;
  }

  public List<PascalByteString> getServiceCertificate() {
    return serviceCertificate;
  }

  public PascalString getIssuerEndpointSettings() {
    return issuerEndpointSettings;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AuthorizationServiceConfigurationDataType");

    // Simple Field (name)
    writeSimpleField("name", name, writeComplex(writeBuffer));

    // Implicit Field (noOfRecordProperties) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfRecordProperties =
        (int) ((((getRecordProperties()) == (null)) ? -(1) : COUNT(getRecordProperties())));
    writeImplicitField(
        "noOfRecordProperties", noOfRecordProperties, writeSignedInt(writeBuffer, 32));

    // Array Field (recordProperties)
    writeComplexTypeArrayField("recordProperties", recordProperties, writeBuffer);

    // Simple Field (serviceUri)
    writeSimpleField("serviceUri", serviceUri, writeComplex(writeBuffer));

    // Implicit Field (noOfServiceCertificate) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfServiceCertificate =
        (int) ((((getServiceCertificate()) == (null)) ? -(1) : COUNT(getServiceCertificate())));
    writeImplicitField(
        "noOfServiceCertificate", noOfServiceCertificate, writeSignedInt(writeBuffer, 32));

    // Array Field (serviceCertificate)
    writeComplexTypeArrayField("serviceCertificate", serviceCertificate, writeBuffer);

    // Simple Field (issuerEndpointSettings)
    writeSimpleField("issuerEndpointSettings", issuerEndpointSettings, writeComplex(writeBuffer));

    writeBuffer.popContext("AuthorizationServiceConfigurationDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AuthorizationServiceConfigurationDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Implicit Field (noOfRecordProperties)
    lengthInBits += 32;

    // Array field
    if (recordProperties != null) {
      int i = 0;
      for (KeyValuePair element : recordProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= recordProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (serviceUri)
    lengthInBits += serviceUri.getLengthInBits();

    // Implicit Field (noOfServiceCertificate)
    lengthInBits += 32;

    // Array field
    if (serviceCertificate != null) {
      int i = 0;
      for (PascalByteString element : serviceCertificate) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= serviceCertificate.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (issuerEndpointSettings)
    lengthInBits += issuerEndpointSettings.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("AuthorizationServiceConfigurationDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString name =
        readSimpleField(
            "name", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfRecordProperties =
        readImplicitField("noOfRecordProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> recordProperties =
        readCountArrayField(
            "recordProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfRecordProperties);

    PascalString serviceUri =
        readSimpleField(
            "serviceUri", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfServiceCertificate =
        readImplicitField("noOfServiceCertificate", readSignedInt(readBuffer, 32));

    List<PascalByteString> serviceCertificate =
        readCountArrayField(
            "serviceCertificate",
            readComplex(() -> PascalByteString.staticParse(readBuffer), readBuffer),
            noOfServiceCertificate);

    PascalString issuerEndpointSettings =
        readSimpleField(
            "issuerEndpointSettings",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("AuthorizationServiceConfigurationDataType");
    // Create the instance
    return new AuthorizationServiceConfigurationDataTypeBuilderImpl(
        name, recordProperties, serviceUri, serviceCertificate, issuerEndpointSettings);
  }

  public static class AuthorizationServiceConfigurationDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString name;
    private final List<KeyValuePair> recordProperties;
    private final PascalString serviceUri;
    private final List<PascalByteString> serviceCertificate;
    private final PascalString issuerEndpointSettings;

    public AuthorizationServiceConfigurationDataTypeBuilderImpl(
        PascalString name,
        List<KeyValuePair> recordProperties,
        PascalString serviceUri,
        List<PascalByteString> serviceCertificate,
        PascalString issuerEndpointSettings) {
      this.name = name;
      this.recordProperties = recordProperties;
      this.serviceUri = serviceUri;
      this.serviceCertificate = serviceCertificate;
      this.issuerEndpointSettings = issuerEndpointSettings;
    }

    public AuthorizationServiceConfigurationDataType build() {
      AuthorizationServiceConfigurationDataType authorizationServiceConfigurationDataType =
          new AuthorizationServiceConfigurationDataType(
              name, recordProperties, serviceUri, serviceCertificate, issuerEndpointSettings);
      return authorizationServiceConfigurationDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AuthorizationServiceConfigurationDataType)) {
      return false;
    }
    AuthorizationServiceConfigurationDataType that = (AuthorizationServiceConfigurationDataType) o;
    return (getName() == that.getName())
        && (getRecordProperties() == that.getRecordProperties())
        && (getServiceUri() == that.getServiceUri())
        && (getServiceCertificate() == that.getServiceCertificate())
        && (getIssuerEndpointSettings() == that.getIssuerEndpointSettings())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getName(),
        getRecordProperties(),
        getServiceUri(),
        getServiceCertificate(),
        getIssuerEndpointSettings());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
