/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class ExtensionObject implements Message {

  // Abstract accessors for discriminator values.
  public abstract Boolean getIncludeEncodingMask();

  // Properties.
  protected final ExpandedNodeId typeId;

  public ExtensionObject(ExpandedNodeId typeId) {
    super();
    this.typeId = typeId;
  }

  public abstract ExtensionObjectDefinition getBody();

  public ExpandedNodeId getTypeId() {
    return typeId;
  }

  public int getExtensionId() {
    return (int)
        ((((getTypeId()) == (null))
            ? 0
            : org.apache.plc4x.java.opcua.readwrite.utils.StaticHelper.extensionId(getTypeId())));
  }

  protected abstract void serializeExtensionObjectChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ExtensionObject");

    // Simple Field (typeId)
    writeSimpleField("typeId", typeId, writeComplex(writeBuffer));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    int extensionId = getExtensionId();
    writeBuffer.writeVirtual("extensionId", extensionId);

    // Switch field (Serialize the sub-type)
    serializeExtensionObjectChild(writeBuffer);

    writeBuffer.popContext("ExtensionObject");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    ExtensionObject _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (typeId)
    lengthInBits += typeId.getLengthInBits();

    // A virtual field doesn't have any in- or output.

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static ExtensionObject staticParse(ReadBuffer readBuffer, Boolean includeEncodingMask)
      throws ParseException {
    readBuffer.pullContext("ExtensionObject");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ExpandedNodeId typeId =
        readSimpleField(
            "typeId", readComplex(() -> ExpandedNodeId.staticParse(readBuffer), readBuffer));
    int extensionId =
        readVirtualField(
            "extensionId",
            int.class,
            (((typeId) == (null))
                ? 0
                : org.apache.plc4x.java.opcua.readwrite.utils.StaticHelper.extensionId(typeId)));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    ExtensionObjectBuilder builder = null;
    if (EvaluationHelper.equals(includeEncodingMask, (boolean) false)) {
      builder =
          RootExtensionObject.staticParseExtensionObjectBuilder(
              readBuffer, extensionId, includeEncodingMask);
    } else if (EvaluationHelper.equals(includeEncodingMask, (boolean) true)) {
      builder =
          ExtensionObjectWithMask.staticParseExtensionObjectBuilder(
              readBuffer, extensionId, includeEncodingMask);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "includeEncodingMask="
              + includeEncodingMask
              + "]");
    }

    readBuffer.closeContext("ExtensionObject");
    // Create the instance
    ExtensionObject _extensionObject = builder.build(typeId);
    return _extensionObject;
  }

  public interface ExtensionObjectBuilder {
    ExtensionObject build(ExpandedNodeId typeId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ExtensionObject)) {
      return false;
    }
    ExtensionObject that = (ExtensionObject) o;
    return (getTypeId() == that.getTypeId()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getTypeId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
