/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.plc4x.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class Plc4xConnectResponse extends Plc4xMessage implements Message {

  // Accessors for discriminator values.
  public Plc4xRequestType getRequestType() {
    return Plc4xRequestType.CONNECT_RESPONSE;
  }

  // Properties.
  protected final int connectionId;
  protected final Plc4xResponseCode responseCode;

  public Plc4xConnectResponse(int requestId, int connectionId, Plc4xResponseCode responseCode) {
    super(requestId);
    this.connectionId = connectionId;
    this.responseCode = responseCode;
  }

  public int getConnectionId() {
    return connectionId;
  }

  public Plc4xResponseCode getResponseCode() {
    return responseCode;
  }

  @Override
  protected void serializePlc4xMessageChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("Plc4xConnectResponse");

    // Simple Field (connectionId)
    writeSimpleField(
        "connectionId",
        connectionId,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (responseCode)
    writeSimpleEnumField(
        "responseCode",
        "Plc4xResponseCode",
        responseCode,
        writeEnum(
            Plc4xResponseCode::getValue,
            Plc4xResponseCode::name,
            writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("Plc4xConnectResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    Plc4xConnectResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (connectionId)
    lengthInBits += 16;

    // Simple field (responseCode)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static Plc4xMessageBuilder staticParsePlc4xMessageBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("Plc4xConnectResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int connectionId =
        readSimpleField(
            "connectionId",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    Plc4xResponseCode responseCode =
        readEnumField(
            "responseCode",
            "Plc4xResponseCode",
            readEnum(Plc4xResponseCode::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("Plc4xConnectResponse");
    // Create the instance
    return new Plc4xConnectResponseBuilderImpl(connectionId, responseCode);
  }

  public static class Plc4xConnectResponseBuilderImpl implements Plc4xMessage.Plc4xMessageBuilder {
    private final int connectionId;
    private final Plc4xResponseCode responseCode;

    public Plc4xConnectResponseBuilderImpl(int connectionId, Plc4xResponseCode responseCode) {
      this.connectionId = connectionId;
      this.responseCode = responseCode;
    }

    public Plc4xConnectResponse build(int requestId) {
      Plc4xConnectResponse plc4xConnectResponse =
          new Plc4xConnectResponse(requestId, connectionId, responseCode);
      return plc4xConnectResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Plc4xConnectResponse)) {
      return false;
    }
    Plc4xConnectResponse that = (Plc4xConnectResponse) o;
    return (getConnectionId() == that.getConnectionId())
        && (getResponseCode() == that.getResponseCode())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getConnectionId(), getResponseCode());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
