/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.util.Json;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.generator.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.MethodAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.OperationPostProcessor;
import org.apache.servicecomb.swagger.generator.ParameterProcessor;
import org.apache.servicecomb.swagger.generator.ResponseTypeProcessor;
import org.apache.servicecomb.swagger.generator.SwaggerContextRegister;
import org.apache.servicecomb.swagger.generator.core.AbstractOperationGenerator;
import org.apache.servicecomb.swagger.generator.core.AbstractSwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;
import org.apache.servicecomb.swagger.generator.core.processor.response.DefaultResponseTypeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwaggerGeneratorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerGeneratorUtils.class);
    private static final Set<JavaType> contextTypes = SPIServiceUtils.getOrLoadSortedService(SwaggerContextRegister.class).stream().map(swaggerContextRegister -> TypeFactory.defaultInstance().constructType(swaggerContextRegister.getContextType())).collect(Collectors.toSet());
    private static final Map<Type, ClassAnnotationProcessor<?>> classAnnotationProcessors = new HashMap();
    private static final Map<Type, MethodAnnotationProcessor<?>> methodAnnotationProcessors = new HashMap();
    private static final Map<JavaType, ParameterProcessor<?, ?>> parameterProcessors = new HashMap();
    private static final Map<Type, ResponseTypeProcessor> responseTypeProcessors = new HashMap<Type, ResponseTypeProcessor>();
    private static final DefaultResponseTypeProcessor defaultResponseTypeProcessor = new DefaultResponseTypeProcessor();
    private static final List<OperationPostProcessor> operationPostProcessors = SPIServiceUtils.getOrLoadSortedService(OperationPostProcessor.class);

    private SwaggerGeneratorUtils() {
    }

    public static void postProcessOperation(AbstractSwaggerGenerator swaggerGenerator, AbstractOperationGenerator operationGenerator) {
        for (OperationPostProcessor processor : operationPostProcessors) {
            if (!processor.shouldProcess(swaggerGenerator, operationGenerator)) continue;
            processor.process(swaggerGenerator, operationGenerator);
        }
    }

    public static <ANNOTATION> ClassAnnotationProcessor<ANNOTATION> findClassAnnotationProcessor(Type type) {
        return classAnnotationProcessors.get(type);
    }

    public static <ANNOTATION> MethodAnnotationProcessor<ANNOTATION> findMethodAnnotationProcessor(Type type) {
        return methodAnnotationProcessors.get(type);
    }

    public static <SWAGGER_PARAMETER, ANNOTATION> ParameterProcessor<SWAGGER_PARAMETER, ANNOTATION> findParameterProcessors(Type type) {
        type = TypeFactory.defaultInstance().constructType(type);
        return parameterProcessors.get(type);
    }

    public static ResponseTypeProcessor findResponseTypeProcessor(Type type) {
        ResponseTypeProcessor processor = responseTypeProcessors.get(type);
        if (processor != null) {
            return processor;
        }
        if (type instanceof ParameterizedType) {
            return responseTypeProcessors.getOrDefault(((ParameterizedType)type).getRawType(), defaultResponseTypeProcessor);
        }
        return defaultResponseTypeProcessor;
    }

    public static boolean isContextParameter(JavaType type) {
        return contextTypes.contains(type);
    }

    public static Annotation[] collectAnnotations(BeanPropertyDefinition propertyDefinition) {
        ArrayList annotations = new ArrayList();
        if (propertyDefinition.getField() != null) {
            Collections.addAll(annotations, propertyDefinition.getField().getAnnotated().getAnnotations());
        }
        if (propertyDefinition.getGetter() != null) {
            Collections.addAll(annotations, propertyDefinition.getGetter().getAnnotated().getAnnotations());
        }
        if (propertyDefinition.getSetter() != null) {
            Collections.addAll(annotations, propertyDefinition.getSetter().getAnnotated().getAnnotations());
        }
        return annotations.toArray(new Annotation[0]);
    }

    public static String collectParameterName(Parameter methodParameter) {
        return SwaggerGeneratorUtils.collectParameterName(methodParameter.getDeclaringExecutable(), methodParameter.getAnnotations(), methodParameter.isNamePresent() ? methodParameter.getName() : null);
    }

    public static String collectParameterName(Method method, BeanPropertyDefinition propertyDefinition) {
        Annotation[] annotations = SwaggerGeneratorUtils.collectAnnotations(propertyDefinition);
        return SwaggerGeneratorUtils.collectParameterName(method, annotations, propertyDefinition.getName());
    }

    public static String collectParameterName(Executable executable, Annotation[] annotations, String defaultName) {
        for (Annotation annotation : annotations) {
            String name;
            ParameterProcessor processor = SwaggerGeneratorUtils.findParameterProcessors(annotation.annotationType());
            if (processor == null || !StringUtils.isNotEmpty((CharSequence)(name = processor.getParameterName(annotation)))) continue;
            return name;
        }
        if (StringUtils.isNotEmpty((CharSequence)defaultName)) {
            return defaultName;
        }
        String msg = String.format("parameter name is not present, method=%s:%s\nsolution:\n  change pom.xml, add compiler argument: -parameters, for example:\n    <plugin>\n      <groupId>org.apache.maven.plugins</groupId>\n      <artifactId>maven-compiler-plugin</artifactId>\n      <configuration>\n        <compilerArgument>-parameters</compilerArgument>\n      </configuration>\n    </plugin>", executable.getDeclaringClass().getName(), executable.getName());
        throw new IllegalStateException(msg);
    }

    public static Type collectGenericType(List<Annotation> annotations, Type defaultType) {
        Type genericType = null;
        for (Annotation annotation : annotations) {
            Type type;
            ParameterProcessor processor = SwaggerGeneratorUtils.findParameterProcessors(annotation.annotationType());
            if (processor == null || (type = processor.getGenericType(annotation)) == null) continue;
            genericType = type;
        }
        return genericType != null ? genericType : defaultType;
    }

    public static List<Annotation> collectParameterAnnotations(Annotation[] parameterAnnotations, Map<String, List<Annotation>> methodAnnotationMap, String parameterName) {
        List<Annotation> methodAnnotations = methodAnnotationMap.remove(parameterName);
        if (methodAnnotations == null) {
            methodAnnotations = Collections.emptyList();
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Collections.addAll(annotations, parameterAnnotations);
        annotations.addAll(methodAnnotations);
        return annotations;
    }

    public static HttpParameterType collectHttpParameterType(List<Annotation> annotations, Type genericType) {
        for (int idx = annotations.size() - 1; idx >= 0; --idx) {
            Annotation annotation = annotations.get(idx);
            HttpParameterType httpParameterType = SwaggerGeneratorUtils.collectHttpParameterType(annotation, annotation.annotationType());
            if (httpParameterType == null) continue;
            return httpParameterType;
        }
        return SwaggerGeneratorUtils.collectHttpParameterType((Annotation)null, genericType);
    }

    private static HttpParameterType collectHttpParameterType(Annotation parameterAnnotation, Type type) {
        ParameterProcessor processor = SwaggerGeneratorUtils.findParameterProcessors(type);
        if (processor == null) {
            return null;
        }
        return processor.getHttpParameterType(parameterAnnotation);
    }

    static {
        for (Object processor : SPIServiceUtils.getOrLoadSortedService(ClassAnnotationProcessor.class)) {
            if (classAnnotationProcessors.putIfAbsent(processor.getProcessType(), (ClassAnnotationProcessor<?>)processor) == null) continue;
            LOGGER.info("ignore duplicated ClassAnnotationProcessor, type={}, processor={}.", (Object)processor.getProcessType().getTypeName(), (Object)processor.getClass().getName());
        }
        for (Object processor : SPIServiceUtils.getOrLoadSortedService(MethodAnnotationProcessor.class)) {
            if (methodAnnotationProcessors.putIfAbsent(processor.getProcessType(), (MethodAnnotationProcessor<?>)processor) == null) continue;
            LOGGER.info("ignore duplicated MethodAnnotationProcessor, type={}, processor={}.", (Object)processor.getProcessType().getTypeName(), (Object)processor.getClass().getName());
        }
        for (Object processor : SPIServiceUtils.getOrLoadSortedService(ParameterProcessor.class)) {
            JavaType javaType = processor.getProcessJavaType();
            if (parameterProcessors.putIfAbsent(javaType, (ParameterProcessor<?, ?>)processor) == null) continue;
            LOGGER.info("ignore duplicated ParameterProcessor, type={}, processor={}.", (Object)javaType.toCanonical(), (Object)processor.getClass().getName());
        }
        for (Object processor : SPIServiceUtils.getOrLoadSortedService(ResponseTypeProcessor.class)) {
            if (responseTypeProcessors.putIfAbsent(processor.getProcessType(), (ResponseTypeProcessor)processor) == null) continue;
            LOGGER.info("ignore duplicated ResponseTypeProcessor, type={}, processor={}.", (Object)processor.getProcessType().getTypeName(), (Object)processor.getClass().getName());
        }
        List modules = SPIServiceUtils.getOrLoadSortedService(Module.class);
        Json.mapper().registerModules(modules.toArray(new Module[0]));
    }
}

