/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.exception;

import org.apache.servicecomb.core.exception.CseException;
import org.apache.servicecomb.foundation.common.RegisterManager;
import org.apache.servicecomb.foundation.common.utils.FortifyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionUtils.class);
    private static final String ERROR_DESC_MGR_MSG = "error desc mgr";
    protected static final RegisterManager<String, String> ERROR_DESC_MGR = new RegisterManager("error desc mgr");
    private static final String SERVICECOMB_HANDLER_REF_NOT_EXIST = "servicecomb.handler.ref.not.exist";
    private static final String SERVICECOMB_PRODUCER_OPERATION_NOT_EXIST = "servicecomb.producer.operation.not.exist";
    private static final String SERVICECOMB_LB_NO_AVAILABLE_ADDRESS = "servicecomb.lb.no.available.address";

    protected ExceptionUtils() {
    }

    public static CseException createCseException(String code, Object ... args) {
        String msg = String.format((String)ERROR_DESC_MGR.ensureFindValue((Object)code), args);
        CseException exception = new CseException(code, msg);
        LOGGER.error(FortifyUtils.getErrorInfo((Throwable)exception));
        return exception;
    }

    public static CseException createCseException(String code, Throwable cause, Object ... args) {
        String msg = String.format((String)ERROR_DESC_MGR.ensureFindValue((Object)code), args);
        CseException exception = new CseException(code, msg, cause);
        LOGGER.error(FortifyUtils.getErrorInfo((Throwable)exception));
        return exception;
    }

    public static CseException producerOperationNotExist(String schemaId, String operationName) {
        return ExceptionUtils.createCseException(SERVICECOMB_PRODUCER_OPERATION_NOT_EXIST, schemaId, operationName);
    }

    public static CseException handlerRefNotExist(String id) {
        return ExceptionUtils.createCseException(SERVICECOMB_HANDLER_REF_NOT_EXIST, id);
    }

    public static CseException lbAddressNotFound(String microserviceName, String microserviceVersionRule, String discoveryGroupName) {
        return ExceptionUtils.createCseException(SERVICECOMB_LB_NO_AVAILABLE_ADDRESS, microserviceName, microserviceVersionRule, discoveryGroupName);
    }

    static {
        ERROR_DESC_MGR.register((Object)SERVICECOMB_HANDLER_REF_NOT_EXIST, (Object)"Handler not exist, id=%s");
        ERROR_DESC_MGR.register((Object)SERVICECOMB_PRODUCER_OPERATION_NOT_EXIST, (Object)"Producer operation not exist, schemaId=%s, operationName=%s");
        ERROR_DESC_MGR.register((Object)SERVICECOMB_LB_NO_AVAILABLE_ADDRESS, (Object)"No available address found. microserviceName=%s, version=%s, discoveryGroupName=%s");
    }
}

