/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactSet;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.Dumpable;
import org.apache.jackrabbit.vault.fs.api.ItemFilter;
import org.apache.jackrabbit.vault.fs.api.ItemFilterSet;
import org.apache.jackrabbit.vault.fs.impl.PropertyValueArtifact;
import org.apache.jackrabbit.vault.fs.impl.SerializerArtifact;
import org.apache.jackrabbit.vault.fs.io.Serializer;

public class ArtifactSetImpl
implements Dumpable,
ArtifactSet {
    private final List<Artifact> artifacts = new LinkedList<Artifact>();
    private List<Artifact> removed;
    private final Map<ArtifactType, Artifact> single = new EnumMap<ArtifactType, Artifact>(ArtifactType.class);
    private Set<Artifact> hints;
    private ItemFilterSet coverageFilter = (ItemFilterSet)new ItemFilterSet().addInclude(ItemFilter.ALL);

    @Override
    public ItemFilterSet getCoverage() {
        return this.coverageFilter;
    }

    public void setCoverage(ItemFilterSet filter) {
        this.coverageFilter = filter;
    }

    @Override
    public void addAll(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            this.add(artifact);
        }
    }

    @Override
    public void addAll(ArtifactSet artifacts) {
        this.addAll(((ArtifactSetImpl)artifacts).artifacts);
    }

    @Override
    public void add(Artifact artifact) {
        ArtifactType type = artifact.getType();
        if (type == ArtifactType.PRIMARY || type == ArtifactType.DIRECTORY) {
            if (this.single.containsKey((Object)type)) {
                throw new IllegalArgumentException("Only 1 " + (Object)((Object)type) + " artifact allowed.");
            }
            this.single.put(type, artifact);
            this.artifacts.add(artifact);
        } else if (type == ArtifactType.HINT) {
            if (this.hints == null) {
                this.hints = new HashSet<Artifact>();
            }
            this.hints.add(artifact);
        } else {
            this.artifacts.add(artifact);
        }
    }

    public SerializerArtifact add(Artifact parent, String name, String ext, ArtifactType type, Serializer ser, long lastModified) {
        SerializerArtifact a = new SerializerArtifact(parent, name, ext, type, ser, lastModified);
        this.add(a);
        return a;
    }

    public Collection<PropertyValueArtifact> add(Artifact parent, String relPath, String ext, ArtifactType type, Property prop, long lastModified) throws RepositoryException {
        Collection<PropertyValueArtifact> a = PropertyValueArtifact.create(parent, relPath, ext, type, prop, lastModified);
        this.addAll(a);
        return a;
    }

    @Override
    public Artifact getPrimaryData() {
        return this.single.get((Object)ArtifactType.PRIMARY);
    }

    @Override
    public Artifact getDirectory() {
        return this.single.get((Object)ArtifactType.DIRECTORY);
    }

    @Override
    public boolean isEmpty() {
        return this.artifacts.isEmpty();
    }

    @Override
    public int size() {
        return this.artifacts.size();
    }

    public boolean remove(Artifact a) {
        if (this.artifacts.remove(a)) {
            this.single.remove((Object)a.getType());
            if (this.removed == null) {
                this.removed = new LinkedList<Artifact>();
                this.removed.add(a);
            }
            return true;
        }
        return false;
    }

    public Artifact put(Artifact a) {
        Artifact prev = null;
        int idx = this.artifacts.indexOf(a);
        if (idx >= 0) {
            prev = this.artifacts.remove(idx);
        }
        this.single.put(a.getType(), a);
        this.artifacts.add(a);
        return prev;
    }

    public int size(ArtifactType type) {
        int num = 0;
        if (type == ArtifactType.HINT) {
            num = this.hints == null ? 0 : this.hints.size();
        } else {
            for (Artifact a : this.artifacts) {
                if (a.getType() != type) continue;
                ++num;
            }
        }
        return num;
    }

    @Override
    public Collection<Artifact> values(ArtifactType type) {
        LinkedList<Artifact> ret = new LinkedList<Artifact>();
        if (type == ArtifactType.HINT) {
            if (this.hints != null) {
                ret.addAll(this.hints);
            }
        } else {
            for (Artifact a : this.artifacts) {
                if (type != null && a.getType() != type) continue;
                ret.add(a);
            }
        }
        return ret;
    }

    @Override
    public Collection<Artifact> values() {
        return Collections.unmodifiableList(this.artifacts);
    }

    @Override
    public Collection<Artifact> removed() {
        if (this.removed == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.removed);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("ArtifactSet={");
        Iterator<Artifact> iter = this.artifacts.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    public Artifact getArtifact(String path) {
        for (Artifact a : this.artifacts) {
            if (!a.getRelativePath().equals(path)) continue;
            return a;
        }
        return null;
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, "Artifacts");
        ctx.indent(isLast);
        for (Artifact a : this.artifacts) {
            a.dump(ctx, false);
        }
        ctx.println(true, "Coverage");
        ctx.indent(true);
        this.coverageFilter.dump(ctx, true);
        ctx.outdent();
        ctx.outdent();
    }
}

