/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.spi2davex;

import java.util.Map;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.RepositoryService;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.RepositoryServiceFactory;
import relocated_for_contentpackage.org.apache.jackrabbit.spi2davex.BatchReadConfig;
import relocated_for_contentpackage.org.apache.jackrabbit.spi2davex.RepositoryServiceImpl;

public class Spi2davexRepositoryServiceFactory
implements RepositoryServiceFactory {
    public static final String PARAM_REPOSITORY_URI = "relocated_for_contentpackage.org.apache.jackrabbit.spi2davex.uri";
    public static final String DEFAULT_REPOSITORY_URI = "http://localhost:8080/jackrabbit/server";
    public static final String PARAM_BATCHREAD_CONFIG = "relocated_for_contentpackage.org.apache.jackrabbit.spi2davex.BatchReadConfig";
    public static final String PARAM_ITEMINFO_CACHE_SIZE = "relocated_for_contentpackage.org.apache.jackrabbit.spi2davex.ItemInfoCacheSize";
    public static final String PARAM_MAX_CONNECTIONS = "relocated_for_contentpackage.org.apache.jackrabbit.spi2davex.MaxConnections";
    public static final String PARAM_WORKSPACE_NAME_DEFAULT = "relocated_for_contentpackage.org.apache.jackrabbit.spi2davex.WorkspaceNameDefault";

    @Override
    public RepositoryService createRepositoryService(Map<?, ?> parameters) throws RepositoryException {
        String uri;
        if (parameters == null) {
            uri = System.getProperty(PARAM_REPOSITORY_URI);
        } else {
            Object repoUri = parameters.get(PARAM_REPOSITORY_URI);
            String string = uri = repoUri == null ? null : repoUri.toString();
        }
        if (uri == null) {
            uri = DEFAULT_REPOSITORY_URI;
        }
        BatchReadConfig brc = null;
        int itemInfoCacheSize = 5000;
        int maximumHttpConnections = 0;
        String workspaceNameDefault = null;
        if (parameters != null) {
            Object param = parameters.get(PARAM_BATCHREAD_CONFIG);
            if (param != null && param instanceof BatchReadConfig) {
                brc = (BatchReadConfig)param;
            }
            if ((param = parameters.get(PARAM_ITEMINFO_CACHE_SIZE)) != null) {
                try {
                    itemInfoCacheSize = Integer.parseInt(param.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((param = parameters.get(PARAM_MAX_CONNECTIONS)) != null) {
                try {
                    maximumHttpConnections = Integer.parseInt(param.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((param = parameters.get(PARAM_WORKSPACE_NAME_DEFAULT)) != null) {
                workspaceNameDefault = param.toString();
            }
        }
        if (maximumHttpConnections > 0) {
            return new RepositoryServiceImpl(uri, workspaceNameDefault, brc, itemInfoCacheSize, maximumHttpConnections);
        }
        return new RepositoryServiceImpl(uri, workspaceNameDefault, brc, itemInfoCacheSize);
    }
}

