/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.model;

import java.lang.reflect.Constructor;
import java.util.Comparator;
import javax.inject.Inject;

class ParameterCountInjectComparator
implements Comparator<Constructor<?>> {
    ParameterCountInjectComparator() {
    }

    @Override
    public int compare(Constructor<?> o1, Constructor<?> o2) {
        int result = this.compareParameterCount(o2.getParameterTypes().length, o1.getParameterTypes().length);
        if (result == 0) {
            return this.compareInjectAnnotation(o1, o2);
        }
        return result;
    }

    private int compareParameterCount(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private int compareInjectAnnotation(Constructor<?> o1, Constructor<?> o2) {
        boolean hasInject1 = o1.isAnnotationPresent(Inject.class);
        boolean hasInject2 = o2.isAnnotationPresent(Inject.class);
        if (hasInject1 && !hasInject2) {
            return -1;
        }
        if (hasInject2 && !hasInject1) {
            return 1;
        }
        return 0;
    }
}

