/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl.components;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Serializer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class Html5Serializer
implements Serializer {
    private static final int CHAR_EQ = 61;
    private static final int CHAR_GT = 62;
    private static final int CHAR_LT = 60;
    private static final int CHAR_QT = 34;
    private static final int CHAR_SP = 32;
    private static final String DOCTYPE = "<!DOCTYPE html>";
    private static final Set<String> emptyTags = new HashSet<String>();
    private PrintWriter writer;
    private boolean inScript = false;

    @Override
    public void characters(char[] buffer, int offset, int length) throws SAXException {
        if (length == 0) {
            this.writer.flush();
        } else {
            if (offset < 0 || offset + length > buffer.length) {
                throw new SAXException("Offset / length out of bounds");
            }
            if (this.inScript) {
                this.writer.write(new String(Arrays.copyOfRange(buffer, offset, offset + length)));
            } else {
                this.writer.write(StringEscapeUtils.escapeHtml4((String)new String(Arrays.copyOfRange(buffer, offset, offset + length))));
            }
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void endDocument() throws SAXException {
        this.writer.flush();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!emptyTags.contains(localName)) {
            this.writer.write("</");
            this.writer.write(localName);
            this.writer.write(62);
        }
        this.inScript = false;
    }

    @Override
    public void endPrefixMapping(String s) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ac, int i, int j) throws SAXException {
    }

    @Override
    public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
        if (context.getWriter() == null) {
            throw new IllegalArgumentException("Failed to initialize HTML5Serializer, null writer specified!");
        }
        this.writer = context.getWriter();
    }

    @Override
    public void processingInstruction(String s, String s1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator1) {
    }

    @Override
    public void skippedEntity(String s) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.writer.println(DOCTYPE);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        boolean endSlash = false;
        this.writer.write(60);
        this.writer.write(localName);
        for (int i = 0; i < atts.getLength(); ++i) {
            if ("endSlash".equals(atts.getQName(i))) {
                endSlash = true;
            }
            String value = atts.getValue(i);
            if (this.shouldContinue(localName, atts, i)) continue;
            this.writer.write(32);
            this.writer.write(atts.getLocalName(i));
            this.writer.write(61);
            this.writer.write(34);
            this.writer.write(StringEscapeUtils.escapeHtml4((String)value));
            this.writer.write(34);
        }
        if (endSlash) {
            this.writer.write("/");
        }
        this.writer.write(62);
        this.inScript = "script".equals(localName);
    }

    private boolean shouldContinue(String localName, Attributes atts, int i) {
        if ("endSlash".equals(atts.getQName(i))) {
            return true;
        }
        if ("a".equals(localName) && "shape".equals(atts.getLocalName(i))) {
            return true;
        }
        if ("iframe".equals(localName) && ("frameborder".equals(atts.getLocalName(i)) || "scrolling".equals(atts.getLocalName(i)))) {
            return true;
        }
        if ("br".equals(localName) && "clear".equals(atts.getLocalName(i))) {
            return true;
        }
        return atts.getValue(i) == null;
    }

    @Override
    public void startPrefixMapping(String s, String s1) throws SAXException {
    }

    static {
        emptyTags.addAll(Arrays.asList("area", "base", "br", "col", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"));
    }
}

