/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;

class MockRow
implements Row {
    private final List<String> columnNames;
    private final Node node;

    public MockRow(List<String> columnNames, Node node) {
        this.columnNames = columnNames;
        this.node = node;
    }

    public Value[] getValues() throws RepositoryException {
        Value[] values = new Value[this.columnNames.size()];
        for (int i = 0; i < values.length; ++i) {
            try {
                values[i] = this.getValue(this.columnNames.get(i));
                continue;
            }
            catch (PathNotFoundException ex) {
                values[i] = null;
            }
        }
        return values;
    }

    public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
        return this.node.getProperty(columnName).getValue();
    }

    public Node getNode() throws RepositoryException {
        return this.node;
    }

    public Node getNode(String selectorName) throws RepositoryException {
        return null;
    }

    public String getPath() throws RepositoryException {
        return this.node.getPath();
    }

    public String getPath(String selectorName) throws RepositoryException {
        return null;
    }

    public double getScore() throws RepositoryException {
        return 0.0;
    }

    public double getScore(String selectorName) throws RepositoryException {
        return 0.0;
    }
}

