/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.spi.support;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.sling.validation.ValidationFailure;
import org.apache.sling.validation.ValidationResult;
import org.apache.sling.validation.spi.ValidatorContext;
import org.apache.sling.validation.spi.support.DefaultValidationFailure;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class DefaultValidationResult
implements ValidationResult,
Serializable {
    private static final long serialVersionUID = -3370520716090956033L;
    private final boolean isValid;
    @NotNull
    private final List<ValidationFailure> failures;
    @NotNull
    public static final DefaultValidationResult VALID = new DefaultValidationResult(true);

    private DefaultValidationResult(boolean isValid) {
        this.isValid = isValid;
        this.failures = Collections.emptyList();
    }

    public DefaultValidationResult(@NotNull ValidatorContext validationContext, @NotNull String messageKey, Object ... messageArguments) {
        this.isValid = false;
        this.failures = Collections.singletonList(new DefaultValidationFailure(validationContext, messageKey, messageArguments));
    }

    public DefaultValidationResult(@NotNull String location, int severity, @NotNull ResourceBundle defaultResourceBundle, @NotNull String messageKey, Object ... messageArguments) {
        this.isValid = false;
        this.failures = Collections.singletonList(new DefaultValidationFailure(location, severity, defaultResourceBundle, messageKey, messageArguments));
    }

    public DefaultValidationResult(ValidationFailure ... failures) {
        this.isValid = false;
        this.failures = Arrays.asList(failures);
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    @NotNull
    public List<ValidationFailure> getFailures() {
        return this.failures;
    }
}

