/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import org.apache.storm.messaging.netty.INettySerializable;
import org.apache.storm.shade.io.netty.buffer.ByteBuf;
import org.apache.storm.shade.io.netty.buffer.Unpooled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslMessageToken
implements INettySerializable {
    public static final short IDENTIFIER = -500;
    private static final Logger LOG = LoggerFactory.getLogger(SaslMessageToken.class);
    private byte[] token;

    public SaslMessageToken() {
    }

    public SaslMessageToken(byte[] token) {
        this.token = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SaslMessageToken read(byte[] serial) {
        ByteBuf smBuffer = Unpooled.wrappedBuffer((byte[])serial);
        try {
            short identifier = smBuffer.readShort();
            int payloadLen = smBuffer.readInt();
            if (identifier != -500) {
                SaslMessageToken saslMessageToken = null;
                return saslMessageToken;
            }
            byte[] token = new byte[payloadLen];
            smBuffer.readBytes(token, 0, payloadLen);
            SaslMessageToken saslMessageToken = new SaslMessageToken(token);
            return saslMessageToken;
        }
        finally {
            smBuffer.release();
        }
    }

    public byte[] getSaslToken() {
        return this.token;
    }

    public void setSaslToken(byte[] token) {
        this.token = token;
    }

    @Override
    public int encodeLength() {
        return 6 + this.token.length;
    }

    @Override
    public void write(ByteBuf dest) {
        int payloadLen = 0;
        if (this.token != null) {
            payloadLen = this.token.length;
        }
        dest.writeShort(-500);
        dest.writeInt(payloadLen);
        if (payloadLen > 0) {
            dest.writeBytes(this.token);
        }
    }
}

