/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.core;

import ch.qos.logback.classic.Level;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.cli.CheckCommand;
import io.dropwizard.core.cli.Cli;
import io.dropwizard.core.cli.ServerCommand;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.logging.common.BootstrapLogging;
import io.dropwizard.util.Generics;
import io.dropwizard.util.JarLocation;

public abstract class Application<T extends Configuration> {
    protected Application() {
        this.bootstrapLogging();
    }

    protected Level bootstrapLogLevel() {
        return Level.WARN;
    }

    protected void bootstrapLogging() {
        BootstrapLogging.bootstrap((Level)this.bootstrapLogLevel());
    }

    public Class<T> getConfigurationClass() {
        return Generics.getTypeParameter(this.getClass(), Configuration.class);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void initialize(Bootstrap<T> bootstrap) {
    }

    public abstract void run(T var1, Environment var2) throws Exception;

    public void run(String ... arguments) throws Exception {
        Bootstrap bootstrap = new Bootstrap(this);
        this.addDefaultCommands(bootstrap);
        this.initialize(bootstrap);
        bootstrap.registerMetrics();
        Cli cli = new Cli(new JarLocation(this.getClass()), bootstrap, System.out, System.err);
        cli.run(arguments).ifPresent(this::onFatalError);
    }

    protected void addDefaultCommands(Bootstrap<T> bootstrap) {
        bootstrap.addCommand(new ServerCommand(this));
        bootstrap.addCommand(new CheckCommand(this));
    }

    protected void onFatalError(Throwable t) {
        System.exit(1);
    }
}

