/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.collections4.properties;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OrderedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private final LinkedHashSet<Object> orderedKeys = new LinkedHashSet();

    @Override
    public synchronized void clear() {
        this.orderedKeys.clear();
        super.clear();
    }

    @Override
    public synchronized Object compute(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        Object compute = super.compute(key, remappingFunction);
        if (compute != null) {
            this.orderedKeys.add(key);
        }
        return compute;
    }

    @Override
    public synchronized Object computeIfAbsent(Object key, Function<? super Object, ? extends Object> mappingFunction) {
        Object computeIfAbsent = super.computeIfAbsent(key, mappingFunction);
        if (computeIfAbsent != null) {
            this.orderedKeys.add(key);
        }
        return computeIfAbsent;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.orderedKeys.stream().map(k -> new AbstractMap.SimpleEntry<Object, Object>(k, this.get(k))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
        Objects.requireNonNull(action);
        this.orderedKeys.forEach((? super T k) -> action.accept(k, this.get(k)));
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(this.orderedKeys);
    }

    @Override
    public Set<Object> keySet() {
        return this.orderedKeys;
    }

    @Override
    public synchronized Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        this.orderedKeys.add(key);
        return super.merge(key, value, remappingFunction);
    }

    @Override
    public Enumeration<?> propertyNames() {
        return Collections.enumeration(this.orderedKeys);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object put = super.put(key, value);
        if (put == null) {
            this.orderedKeys.add(key);
        }
        return put;
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        this.orderedKeys.addAll(t.keySet());
        super.putAll(t);
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        Object putIfAbsent = super.putIfAbsent(key, value);
        if (putIfAbsent == null) {
            this.orderedKeys.add(key);
        }
        return putIfAbsent;
    }

    @Override
    public synchronized Object remove(Object key) {
        Object remove = super.remove(key);
        if (remove != null) {
            this.orderedKeys.remove(key);
        }
        return remove;
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        boolean remove = super.remove(key, value);
        if (remove) {
            this.orderedKeys.remove(key);
        }
        return remove;
    }

    @Override
    public synchronized String toString() {
        int max = this.size() - 1;
        if (max == -1) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<Object, Object>> it = this.entrySet().iterator();
        sb.append('{');
        int i = 0;
        while (true) {
            Map.Entry<Object, Object> e = it.next();
            Object key = e.getKey();
            Object value = e.getValue();
            sb.append(key == this ? "(this Map)" : key.toString());
            sb.append('=');
            sb.append(value == this ? "(this Map)" : value.toString());
            if (i == max) {
                return sb.append('}').toString();
            }
            sb.append(", ");
            ++i;
        }
    }
}

