/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tapestry5.ioc.Invokable;

public class ConcurrentBarrier {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ThreadBoolean threadHasReadLock = new ThreadBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withRead(Invokable<T> invokable) {
        boolean readLockedAtEntry;
        ThreadBoolean threadBoolean = this.threadHasReadLock;
        synchronized (threadBoolean) {
            readLockedAtEntry = (Boolean)this.threadHasReadLock.get();
        }
        if (!readLockedAtEntry) {
            this.lock.readLock().lock();
            threadBoolean = this.threadHasReadLock;
            synchronized (threadBoolean) {
                this.threadHasReadLock.set(true);
            }
        }
        try {
            threadBoolean = invokable.invoke();
            return (T)threadBoolean;
        }
        finally {
            if (!readLockedAtEntry) {
                this.lock.readLock().unlock();
                ThreadBoolean threadBoolean2 = this.threadHasReadLock;
                synchronized (threadBoolean2) {
                    this.threadHasReadLock.remove();
                }
            }
        }
    }

    public void withRead(final Runnable runnable) {
        Invokable<Void> invokable = new Invokable<Void>(){

            @Override
            public Void invoke() {
                runnable.run();
                return null;
            }
        };
        this.withRead(invokable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withWrite(Invokable<T> invokable) {
        boolean readLockedAtEntry = this.releaseReadLock();
        this.lock.writeLock().lock();
        try {
            T t = invokable.invoke();
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
            this.restoreReadLock(readLockedAtEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean releaseReadLock() {
        boolean readLockedAtEntry;
        ThreadBoolean threadBoolean = this.threadHasReadLock;
        synchronized (threadBoolean) {
            readLockedAtEntry = (Boolean)this.threadHasReadLock.get();
        }
        if (readLockedAtEntry) {
            this.lock.readLock().unlock();
            threadBoolean = this.threadHasReadLock;
            synchronized (threadBoolean) {
                this.threadHasReadLock.set(false);
            }
        }
        return readLockedAtEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreReadLock(boolean readLockedAtEntry) {
        if (readLockedAtEntry) {
            this.lock.readLock().lock();
            ThreadBoolean threadBoolean = this.threadHasReadLock;
            synchronized (threadBoolean) {
                this.threadHasReadLock.set(true);
            }
        }
        ThreadBoolean threadBoolean = this.threadHasReadLock;
        synchronized (threadBoolean) {
            this.threadHasReadLock.remove();
        }
    }

    public void withWrite(final Runnable runnable) {
        Invokable<Void> invokable = new Invokable<Void>(){

            @Override
            public Void invoke() {
                runnable.run();
                return null;
            }
        };
        this.withWrite(invokable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryWithWrite(Runnable runnable, long timeout, TimeUnit timeoutUnit) {
        boolean readLockedAtEntry = this.releaseReadLock();
        boolean obtainedLock = false;
        try {
            try {
                obtainedLock = this.lock.writeLock().tryLock(timeout, timeoutUnit);
                if (obtainedLock) {
                    runnable.run();
                }
            }
            catch (InterruptedException e) {
                obtainedLock = false;
            }
            finally {
                if (obtainedLock) {
                    this.lock.writeLock().unlock();
                }
            }
        }
        finally {
            this.restoreReadLock(readLockedAtEntry);
        }
        return obtainedLock;
    }

    private static class ThreadBoolean
    extends ThreadLocal<Boolean> {
        private ThreadBoolean() {
        }

        @Override
        protected Boolean initialValue() {
            return false;
        }
    }
}

