/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.ajax;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.internal.services.PageRenderQueue;
import org.apache.tapestry5.internal.services.ajax.AjaxFormUpdateController;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.runtime.RenderQueue;
import org.apache.tapestry5.services.PartialMarkupRenderer;
import org.apache.tapestry5.services.PartialMarkupRendererFilter;

public class SingleZonePartialRendererFilter
implements PartialMarkupRendererFilter {
    private final String zoneId;
    private final RenderCommand zoneRenderCommand;
    private final PageRenderQueue queue;
    private final AjaxFormUpdateController ajaxFormUpdateController;

    public SingleZonePartialRendererFilter(String zoneId, RenderCommand zoneRenderCommand, PageRenderQueue queue, AjaxFormUpdateController ajaxFormUpdateController) {
        this.zoneId = zoneId;
        this.zoneRenderCommand = zoneRenderCommand;
        this.queue = queue;
        this.ajaxFormUpdateController = ajaxFormUpdateController;
    }

    @Override
    public void renderMarkup(MarkupWriter writer, final JSONObject reply, PartialMarkupRenderer renderer) {
        RenderCommand forZone = new RenderCommand(){

            @Override
            public void render(MarkupWriter writer, RenderQueue queue) {
                final Element zoneContainer = writer.element("zone-update", "zoneId", SingleZonePartialRendererFilter.this.zoneId);
                SingleZonePartialRendererFilter.this.ajaxFormUpdateController.setupBeforePartialZoneRender(writer);
                queue.push(new RenderCommand(){

                    @Override
                    public void render(MarkupWriter writer, RenderQueue queue) {
                        writer.end();
                        SingleZonePartialRendererFilter.this.ajaxFormUpdateController.cleanupAfterPartialZoneRender();
                        String zoneUpdateContent = zoneContainer.getChildMarkup();
                        zoneContainer.remove();
                        reply.in("_tapestry").append("content", (Object)new JSONArray(new Object[]{SingleZonePartialRendererFilter.this.zoneId, zoneUpdateContent}));
                    }
                });
                queue.push(SingleZonePartialRendererFilter.this.zoneRenderCommand);
            }
        };
        this.queue.addPartialRenderer(forZone);
        renderer.renderMarkup(writer, reply);
    }
}

