/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.translator.AbstractTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.TranslatorException;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;

public class PythonTranslateVisitor
extends AbstractTranslateVisitor {
    public PythonTranslateVisitor() {
        super("g");
    }

    public PythonTranslateVisitor(String graphTraversalSourceName) {
        super(graphTraversalSourceName);
    }

    @Override
    public Void visitBooleanLiteral(GremlinParser.BooleanLiteralContext ctx) {
        String text = ctx.getText();
        this.sb.append(text.substring(0, 1).toUpperCase()).append(text.substring(1));
        return null;
    }

    public Void visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        if (ctx.getChildCount() == 1) {
            this.sb.append(ctx.getText()).append("()");
        } else {
            this.sb.append(ctx.getChild(0).getText().equals("new") ? ctx.getChild(1).getText() : ctx.getChild(0).getText()).append("(");
            List configs = ctx.children.stream().filter(c -> c instanceof GremlinParser.ConfigurationContext).collect(Collectors.toList());
            for (int ix = 0; ix < configs.size(); ++ix) {
                this.visit((ParseTree)configs.get(ix));
                if (ix >= configs.size() - 1) continue;
                this.sb.append(", ");
            }
            this.sb.append(")");
        }
        return null;
    }

    public Void visitConfiguration(GremlinParser.ConfigurationContext ctx) {
        this.sb.append(SymbolHelper.toPython(ctx.getChild(0).getText()));
        this.sb.append("=");
        this.visit(ctx.getChild(2));
        return null;
    }

    public Void visitTraversalSourceSelfMethod_withoutStrategies(GremlinParser.TraversalSourceSelfMethod_withoutStrategiesContext ctx) {
        this.sb.append(SymbolHelper.toPython(ctx.getChild(0).getText())).append("(*[");
        this.visit((ParseTree)ctx.classType());
        if (ctx.classTypeList() != null && ctx.classTypeList().getChildCount() > 0) {
            this.sb.append(", ");
            this.visit((ParseTree)ctx.classTypeList());
        }
        this.sb.append("])");
        return null;
    }

    public Void visitClassType(GremlinParser.ClassTypeContext ctx) {
        Optional<? extends Class<? extends TraversalStrategy>> strategy = TraversalStrategies.GlobalCache.getRegisteredStrategyClass(ctx.getText());
        String fqcn = strategy.map(Class::getName).orElse(ctx.getText());
        this.sb.append("GremlinType('").append(fqcn).append("')");
        return null;
    }

    public Void visitGenericMapLiteral(GremlinParser.GenericMapLiteralContext ctx) {
        this.sb.append("{ ");
        for (int i = 0; i < ctx.mapEntry().size(); ++i) {
            GremlinParser.MapEntryContext mapEntryContext = ctx.mapEntry(i);
            this.visit((ParseTree)mapEntryContext);
            if (i >= ctx.mapEntry().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append(" }");
        return null;
    }

    public Void visitMapEntry(GremlinParser.MapEntryContext ctx) {
        GremlinParser.MapKeyContext mapKeyContext = ctx.mapKey();
        this.visit((ParseTree)mapKeyContext);
        this.sb.append(": ");
        this.visit(ctx.getChild(2));
        return null;
    }

    public Void visitMapKey(GremlinParser.MapKeyContext ctx) {
        int keyIndex = ctx.LPAREN() != null && ctx.RPAREN() != null ? 1 : 0;
        this.visit(ctx.getChild(keyIndex));
        return null;
    }

    public Void visitDateLiteral(GremlinParser.DateLiteralContext ctx) {
        String dtString = ctx.getChild(2).getText();
        String dt = DatetimeHelper.parse(PythonTranslateVisitor.removeFirstAndLastCharacters(dtString)).toString();
        String dtISOString = dt.endsWith("Z") ? dt.replace("Z", "+00:00") : dt;
        this.sb.append("datetime.datetime.fromisoformat('").append(dtISOString).append("')");
        return null;
    }

    @Override
    public Void visitNullLiteral(GremlinParser.NullLiteralContext ctx) {
        this.sb.append("None");
        return null;
    }

    @Override
    public Void visitNanLiteral(GremlinParser.NanLiteralContext ctx) {
        this.sb.append("float('nan')");
        return null;
    }

    @Override
    public Void visitInfLiteral(GremlinParser.InfLiteralContext ctx) {
        if (ctx.SignedInfLiteral() != null && ctx.SignedInfLiteral().getText().equals("-Infinity")) {
            this.sb.append("float('-inf')");
        } else {
            this.sb.append("float('inf')");
        }
        return null;
    }

    @Override
    public Void visitStringNullableLiteral(GremlinParser.StringNullableLiteralContext ctx) {
        if (ctx.getText().equals("null")) {
            this.sb.append("None");
        } else {
            String text = PythonTranslateVisitor.removeFirstAndLastCharacters(ctx.getText());
            this.handleStringLiteralText(text);
        }
        return null;
    }

    @Override
    public Void visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        BigInteger bi;
        int lastCharIndex;
        Object integerLiteral = ctx.getText().toLowerCase();
        int lastChar = ((String)integerLiteral).charAt(lastCharIndex = ((String)integerLiteral).length() - 1);
        if (!Character.isAlphabetic(lastChar) && (bi = new BigInteger((String)integerLiteral)).bitLength() > 32) {
            integerLiteral = (String)integerLiteral + "l";
            lastChar = 108;
            ++lastCharIndex;
        }
        switch (lastChar) {
            case 98: 
            case 105: 
            case 115: {
                this.sb.append((CharSequence)integerLiteral, 0, lastCharIndex);
                break;
            }
            case 110: {
                this.sb.append("bigint(");
                this.sb.append((CharSequence)integerLiteral, 0, lastCharIndex);
                this.sb.append(")");
                break;
            }
            case 108: {
                this.sb.append("long(");
                this.sb.append((CharSequence)integerLiteral, 0, lastCharIndex);
                this.sb.append(")");
                break;
            }
            default: {
                this.sb.append((String)integerLiteral);
            }
        }
        return null;
    }

    @Override
    public Void visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        if (ctx.infLiteral() != null) {
            return (Void)this.visit((ParseTree)ctx.infLiteral());
        }
        if (ctx.nanLiteral() != null) {
            return (Void)this.visit((ParseTree)ctx.nanLiteral());
        }
        String floatLiteral = ctx.getText().toLowerCase();
        int lastCharIndex = floatLiteral.length() - 1;
        char lastChar = floatLiteral.charAt(lastCharIndex);
        switch (lastChar) {
            case 'd': 
            case 'f': {
                this.sb.append(floatLiteral, 0, lastCharIndex);
                break;
            }
            case 'm': {
                this.sb.append("bigdecimal(");
                this.sb.append(floatLiteral, 0, lastCharIndex);
                this.sb.append(")");
                break;
            }
            default: {
                this.sb.append(floatLiteral);
            }
        }
        return null;
    }

    public Void visitGenericRangeLiteral(GremlinParser.GenericRangeLiteralContext ctx) {
        throw new TranslatorException("Python does not support range literals");
    }

    public Void visitGenericSetLiteral(GremlinParser.GenericSetLiteralContext ctx) {
        if (ctx.genericLiteral().isEmpty()) {
            this.sb.append("set()");
            return null;
        }
        this.sb.append("{");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("}");
        return null;
    }

    public Void visitGenericCollectionLiteral(GremlinParser.GenericCollectionLiteralContext ctx) {
        this.sb.append("[");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("]");
        return null;
    }

    @Override
    public Void visitUuidLiteral(GremlinParser.UuidLiteralContext ctx) {
        if (ctx.stringLiteral() == null) {
            this.sb.append("uuid.uuid4()");
            return null;
        }
        this.sb.append("uuid.UUID(");
        this.visitStringLiteral(ctx.stringLiteral());
        this.sb.append(")");
        return null;
    }

    @Override
    protected String getCardinalityFunctionClass() {
        return "CardinalityValue";
    }

    @Override
    protected String processGremlinSymbol(String step) {
        return SymbolHelper.toPython(step);
    }

    @Override
    protected void handleStringLiteralText(String text) {
        this.sb.append("'");
        this.sb.append(text);
        this.sb.append("'");
    }

    static final class SymbolHelper {
        private static final Map<String, String> TO_PYTHON_MAP = new HashMap<String, String>();
        private static final Map<String, String> FROM_PYTHON_MAP = new HashMap<String, String>();

        private SymbolHelper() {
        }

        public static String toPython(String symbol) {
            return TO_PYTHON_MAP.getOrDefault(symbol, SymbolHelper.convertCamelCaseToSnakeCase(symbol));
        }

        public static String convertCamelCaseToSnakeCase(String camelCase) {
            if (camelCase == null || camelCase.isEmpty()) {
                return camelCase;
            }
            if (Character.isUpperCase(camelCase.charAt(0))) {
                return camelCase;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < camelCase.length(); ++i) {
                char c = camelCase.charAt(i);
                if (Character.isUpperCase(c)) {
                    sb.append("_");
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }

        public static String toJava(String symbol) {
            return FROM_PYTHON_MAP.getOrDefault(symbol, symbol);
        }

        static {
            TO_PYTHON_MAP.put("global", "global_");
            TO_PYTHON_MAP.put("all", "all_");
            TO_PYTHON_MAP.put("and", "and_");
            TO_PYTHON_MAP.put("any", "any_");
            TO_PYTHON_MAP.put("as", "as_");
            TO_PYTHON_MAP.put("filter", "filter_");
            TO_PYTHON_MAP.put("format", "format_");
            TO_PYTHON_MAP.put("from", "from_");
            TO_PYTHON_MAP.put("id", "id_");
            TO_PYTHON_MAP.put("in", "in_");
            TO_PYTHON_MAP.put("is", "is_");
            TO_PYTHON_MAP.put("list", "list_");
            TO_PYTHON_MAP.put("max", "max_");
            TO_PYTHON_MAP.put("min", "min_");
            TO_PYTHON_MAP.put("or", "or_");
            TO_PYTHON_MAP.put("not", "not_");
            TO_PYTHON_MAP.put("range", "range_");
            TO_PYTHON_MAP.put("set", "set_");
            TO_PYTHON_MAP.put("sum", "sum_");
            TO_PYTHON_MAP.put("with", "with_");
            TO_PYTHON_MAP.forEach((k, v) -> FROM_PYTHON_MAP.put((String)v, (String)k));
        }
    }
}

