/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.objenesis.strategy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tinkerpop.shaded.objenesis.ObjenesisException;
import org.apache.tinkerpop.shaded.objenesis.instantiator.ObjectInstantiator;
import org.apache.tinkerpop.shaded.objenesis.strategy.InstantiatorStrategy;

public class SingleInstantiatorStrategy
implements InstantiatorStrategy {
    private final Constructor<?> constructor;

    public <T extends ObjectInstantiator<?>> SingleInstantiatorStrategy(Class<T> instantiator) {
        try {
            this.constructor = instantiator.getConstructor(Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new ObjenesisException(e);
        }
    }

    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        try {
            return (ObjectInstantiator)this.constructor.newInstance(type);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ObjenesisException(e);
        }
    }
}

