/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.grammar;

import java.util.Map;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.language.grammar.DefaultGremlinBaseVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinAntlrToJava;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParserException;
import org.apache.tinkerpop.gremlin.language.grammar.VariableResolver;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;

public class ArgumentVisitor
extends DefaultGremlinBaseVisitor<Object> {
    private final VariableResolver resolver;
    private final GremlinAntlrToJava antlr;

    public ArgumentVisitor(VariableResolver resolver, GremlinAntlrToJava antlr) {
        this.resolver = resolver;
        this.antlr = antlr;
    }

    public Map parseMap(GremlinParser.GenericMapNullableArgumentContext ctx) {
        Object literalOrVar = this.visitGenericMapNullableArgument(ctx);
        if (GValue.valueInstanceOf(literalOrVar, Map.class)) {
            return (Map)((GValue)literalOrVar).get();
        }
        return (Map)literalOrVar;
    }

    public Object[] parseObjectVarargs(GremlinParser.GenericArgumentVarargsContext ctx) {
        if (ctx == null || ctx.genericArgument() == null) {
            return new Object[0];
        }
        return ctx.genericArgument().stream().filter(Objects::nonNull).map(this.antlr.argumentVisitor::visitGenericArgument).toArray(Object[]::new);
    }

    public GValue<String>[] parseStringVarargs(GremlinParser.StringNullableArgumentVarargsContext varargsContext) {
        if (varargsContext == null || varargsContext.stringNullableArgument() == null) {
            return new GValue[0];
        }
        return (GValue[])varargsContext.stringNullableArgument().stream().filter(Objects::nonNull).map(this.antlr.argumentVisitor::parseString).toArray(GValue[]::new);
    }

    public GValue<String> parseString(GremlinParser.StringNullableArgumentContext ctx) {
        Object literalOrVar = this.visitStringNullableArgument(ctx);
        if (GValue.valueInstanceOf(literalOrVar, String.class)) {
            return (GValue)literalOrVar;
        }
        return GValue.ofString(null, (String)literalOrVar);
    }

    public Object parseLong(GremlinParser.IntegerArgumentContext ctx) {
        if (ctx.integerLiteral() != null) {
            return this.antlr.genericVisitor.parseIntegral(ctx.integerLiteral()).longValue();
        }
        Object var = this.visitVariable(ctx.variable());
        if (var instanceof Number) {
            return ((Number)var).longValue();
        }
        if (GValue.valueInstanceOf(var, Long.class)) {
            return var;
        }
        if (GValue.valueInstanceOf(var, Integer.class)) {
            return GValue.ofLong(((GValue)var).getName(), ((Integer)((GValue)var).get()).longValue());
        }
        if (GValue.valueInstanceOf(var, Short.class)) {
            return GValue.ofLong(((GValue)var).getName(), ((Short)((GValue)var).get()).longValue());
        }
        if (GValue.valueInstanceOf(var, Byte.class)) {
            return GValue.ofLong(((GValue)var).getName(), ((Byte)((GValue)var).get()).longValue());
        }
        throw new GremlinParserException(String.format("Expected variable [%s] to resolve to an integer type, instead found: %s", ctx.variable().Identifier().getSymbol(), var.getClass().getName()));
    }

    @Override
    public Object visitBooleanArgument(GremlinParser.BooleanArgumentContext ctx) {
        if (ctx.booleanLiteral() != null) {
            return this.antlr.genericVisitor.parseBoolean(ctx.booleanLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitIntegerArgument(GremlinParser.IntegerArgumentContext ctx) {
        if (ctx.integerLiteral() != null) {
            return this.antlr.genericVisitor.parseIntegral(ctx.integerLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitFloatArgument(GremlinParser.FloatArgumentContext ctx) {
        if (ctx.floatLiteral() != null) {
            return this.antlr.genericVisitor.parseFloating(ctx.floatLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitStringArgument(GremlinParser.StringArgumentContext ctx) {
        if (ctx.stringLiteral() != null) {
            return this.antlr.genericVisitor.parseString(ctx.stringLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitStringNullableArgument(GremlinParser.StringNullableArgumentContext ctx) {
        if (ctx.stringNullableLiteral() != null) {
            return this.antlr.genericVisitor.parseString(ctx.stringNullableLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitStringNullableArgumentVarargs(GremlinParser.StringNullableArgumentVarargsContext ctx) {
        if (ctx == null || ctx.stringNullableArgument() == null) {
            return new Object[0];
        }
        return ctx.stringNullableArgument().stream().filter(Objects::nonNull).map(this.antlr.argumentVisitor::visitStringNullableArgument).toArray();
    }

    @Override
    public Object visitDateArgument(GremlinParser.DateArgumentContext ctx) {
        if (ctx.dateLiteral() != null) {
            return this.antlr.genericVisitor.parseDate(ctx.dateLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitGenericArgument(GremlinParser.GenericArgumentContext ctx) {
        if (ctx.genericLiteral() != null) {
            return this.antlr.genericVisitor.visitGenericLiteral(ctx.genericLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitGenericMapArgument(GremlinParser.GenericMapArgumentContext ctx) {
        if (ctx.genericMapLiteral() != null) {
            return this.antlr.genericVisitor.visitGenericMapLiteral(ctx.genericMapLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitGenericMapNullableArgument(GremlinParser.GenericMapNullableArgumentContext ctx) {
        if (ctx.genericMapNullableLiteral() != null) {
            return this.antlr.genericVisitor.visitGenericMapNullableLiteral(ctx.genericMapNullableLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitVariable(GremlinParser.VariableContext ctx) {
        return this.resolver.apply(ctx.getText(), ctx);
    }

    public static <V> GValue<V> asGValue(V value) {
        if (value instanceof GValue) {
            return (GValue)value;
        }
        return GValue.of(null, value);
    }
}

