/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.structure.io.graphson.JsonParserConcat;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonTypeInfo;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.databind.BeanProperty;
import org.apache.tinkerpop.shaded.jackson.databind.DatabindContext;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JavaType;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeIdResolver;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.impl.TypeDeserializerBase;
import org.apache.tinkerpop.shaded.jackson.databind.type.TypeFactory;
import org.apache.tinkerpop.shaded.jackson.databind.util.TokenBuffer;

public class GraphSONTypeDeserializer
extends TypeDeserializerBase {
    private final TypeIdResolver idRes;
    private final String propertyName;
    private final String valuePropertyName;
    private final JavaType baseType;
    private final TypeInfo typeInfo;
    private static final JavaType mapJavaType = TypeFactory.defaultInstance().constructType(LinkedHashMap.class);
    private static final JavaType arrayJavaType = TypeFactory.defaultInstance().constructType(ArrayList.class);

    GraphSONTypeDeserializer(JavaType baseType, TypeIdResolver idRes, String typePropertyName, TypeInfo typeInfo, String valuePropertyName) {
        super(baseType, idRes, typePropertyName, false, null);
        this.baseType = baseType;
        this.idRes = idRes;
        this.propertyName = typePropertyName;
        this.typeInfo = typeInfo;
        this.valuePropertyName = valuePropertyName;
    }

    public TypeDeserializer forProperty(BeanProperty beanProperty) {
        return this;
    }

    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_ARRAY;
    }

    public TypeIdResolver getTypeIdResolver() {
        return this.idRes;
    }

    public Class<?> getDefaultImpl() {
        return null;
    }

    public Object deserializeTypedFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this.deserialize(jsonParser, deserializationContext);
    }

    public Object deserializeTypedFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this.deserialize(jsonParser, deserializationContext);
    }

    public Object deserializeTypedFromScalar(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this.deserialize(jsonParser, deserializationContext);
    }

    public Object deserializeTypedFromAny(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this.deserialize(jsonParser, deserializationContext);
    }

    private Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        TokenBuffer buf = new TokenBuffer(jsonParser.getCodec(), false);
        TokenBuffer localCopy = new TokenBuffer(jsonParser.getCodec(), false);
        try {
            if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
                String nextFieldName;
                buf.writeStartObject();
                String typeName = null;
                boolean valueDetected = false;
                boolean valueDetectedFirst = false;
                for (int i = 0; i < 2 && (nextFieldName = jsonParser.nextFieldName()) != null && (nextFieldName.equals(this.propertyName) || nextFieldName.equals(this.valuePropertyName)); ++i) {
                    if (nextFieldName.equals(this.propertyName)) {
                        typeName = jsonParser.nextTextValue();
                        buf.writeStringField(this.propertyName, typeName);
                        continue;
                    }
                    if (!nextFieldName.equals(this.valuePropertyName)) continue;
                    jsonParser.nextValue();
                    if (typeName == null) {
                        buf.writeFieldName(this.valuePropertyName);
                        valueDetectedFirst = true;
                        localCopy.copyCurrentStructure(jsonParser);
                    }
                    valueDetected = true;
                }
                if (typeName != null && valueDetected) {
                    JsonParser tokenParser;
                    JavaType typeFromId = this.idRes.typeFromId((DatabindContext)deserializationContext, typeName);
                    if (!(this.baseType.isJavaLangObject() || this.baseType.equals((Object)typeFromId) || this.baseType.getRawClass() == TraversalStrategyProxy.class && TraversalStrategy.class.isAssignableFrom(typeFromId.getRawClass()))) {
                        throw new InstantiationException(String.format("Cannot deserialize the value with the detected type contained in the JSON ('%s') to the type specified in parameter to the object mapper (%s). Those types are incompatible.", typeName, this.baseType.getRawClass().toString()));
                    }
                    JsonDeserializer jsonDeserializer = deserializationContext.findContextualValueDeserializer(typeFromId, null);
                    if (valueDetectedFirst) {
                        tokenParser = localCopy.asParser();
                        tokenParser.nextToken();
                    } else {
                        tokenParser = jsonParser;
                    }
                    Object value = jsonDeserializer.deserialize(tokenParser, deserializationContext);
                    JsonToken t = jsonParser.nextToken();
                    if (t == JsonToken.END_OBJECT) {
                        return value;
                    }
                    throw deserializationContext.mappingException("Detected the type pattern in the JSON payload but the map containing the types and values contains other fields. This is not allowed by the deserializer.");
                }
            }
        }
        catch (Exception e) {
            throw deserializationContext.mappingException("Could not deserialize the JSON value as required. Nested exception: " + e.toString());
        }
        JsonParser[] concatenatedArray = new JsonParser[]{buf.asParser(), localCopy.asParser(), jsonParser};
        JsonParserConcat parserToUse = new JsonParserConcat(concatenatedArray);
        parserToUse.nextToken();
        if (!this.baseType.isJavaLangObject()) {
            JsonDeserializer jsonDeserializer = deserializationContext.findContextualValueDeserializer(this.baseType, null);
            return jsonDeserializer.deserialize((JsonParser)parserToUse, deserializationContext);
        }
        if (parserToUse.isExpectedStartArrayToken()) {
            return deserializationContext.findContextualValueDeserializer(arrayJavaType, null).deserialize((JsonParser)parserToUse, deserializationContext);
        }
        if (parserToUse.isExpectedStartObjectToken()) {
            return deserializationContext.findContextualValueDeserializer(mapJavaType, null).deserialize((JsonParser)parserToUse, deserializationContext);
        }
        JsonDeserializer jsonDeserializer = deserializationContext.findContextualValueDeserializer(this.baseType, null);
        return jsonDeserializer.deserialize((JsonParser)parserToUse, deserializationContext);
    }

    private boolean canReadTypeId() {
        return this.typeInfo == TypeInfo.PARTIAL_TYPES;
    }
}

